/*
 * Decompiled with CFR 0.152.
 */
package trackapi.lib;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import trackapi.compat.MinecraftRail;
import trackapi.lib.ITrack;
import trackapi.lib.ITrackBlock;

public class Util {
    private static ITrack getInternalTileEntity(final World world, Vec3 pos, boolean acceptMinecraftRails) {
        int posZ;
        int posY;
        final int posX = (int)Math.floor(pos.field_72450_a);
        Block bs = world.func_147439_a(posX, posY = (int)Math.floor(pos.field_72448_b), posZ = (int)Math.floor(pos.field_72449_c));
        if (bs instanceof ITrackBlock) {
            final ITrackBlock track = (ITrackBlock)bs;
            return new ITrack(){

                @Override
                public double getTrackGauge() {
                    return track.getTrackGauge(world, posX, posY, posZ);
                }

                @Override
                public Vec3 getNextPosition(Vec3 currentPosition, Vec3 motion) {
                    return track.getNextPosition(world, posX, posY, posZ, currentPosition, motion);
                }
            };
        }
        TileEntity te = world.func_147438_o(posX, posY, posZ);
        if (te instanceof ITrack) {
            return (ITrack)te;
        }
        if (acceptMinecraftRails && MinecraftRail.isRail(world, posX, posY, posZ)) {
            return new MinecraftRail(world, posX, posY, posZ);
        }
        return null;
    }

    public static ITrack getTileEntity(World world, Vec3 pos, boolean acceptMinecraftRails) {
        ITrack track = Util.getInternalTileEntity(world, pos, acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        track = Util.getInternalTileEntity(world, pos.func_72441_c(0.0, 0.4, 0.0), acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        track = Util.getInternalTileEntity(world, pos.func_72441_c(0.0, -0.4, 0.0), acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        return null;
    }
}

