/*
 * Decompiled with CFR 0.152.
 */
package trackapi.compat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockRailBase;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import trackapi.lib.ITrack;

public class MinecraftRail
implements ITrack {
    private static Map<EnumRailDirection, Vec3> vectors = new HashMap<EnumRailDirection, Vec3>();
    private static Map<EnumRailDirection, Vec3> centers = new HashMap<EnumRailDirection, Vec3>();
    private EnumRailDirection direction;
    private final int posX;
    private final int posY;
    private final int posZ;

    public static Vec3 add(Vec3 a, Vec3 b) {
        return a.func_72441_c(b.field_72450_a, b.field_72448_b, b.field_72449_c);
    }

    public static Vec3 subtract(Vec3 a, Vec3 b) {
        return b.func_72444_a(a);
    }

    public static Vec3 subtractReverse(Vec3 a, Vec3 b) {
        return a.func_72444_a(b);
    }

    public static Vec3 scale(Vec3 a, double b) {
        return Vec3.func_72443_a((double)(a.field_72450_a * b), (double)(a.field_72448_b * b), (double)(a.field_72449_c * b));
    }

    public MinecraftRail(World world, int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.direction = EnumRailDirection.values()[((BlockRailBase)world.func_147439_a(posX, posY, posZ)).getBasicRailMetadata((IBlockAccess)world, null, posX, posY, posZ)];
    }

    @Override
    public double getTrackGauge() {
        return 0.632;
    }

    @Override
    public Vec3 getNextPosition(Vec3 currentPosition, Vec3 motion) {
        Vec3 trackMovement = vectors.get((Object)this.direction);
        Vec3 trackCenter = centers.get((Object)this.direction);
        Vec3 posRelativeToCenter = MinecraftRail.subtractReverse(currentPosition, MinecraftRail.add(Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), trackCenter));
        double distanceToCenter = posRelativeToCenter.func_72433_c();
        boolean trackPosMotionInverted = posRelativeToCenter.func_72438_d(trackMovement) < MinecraftRail.scale(posRelativeToCenter, -1.0).func_72438_d(trackMovement);
        boolean trackMotionInverted = motion.func_72438_d(trackMovement) > MinecraftRail.scale(motion, -1.0).func_72438_d(trackMovement);
        Vec3 newPosition = MinecraftRail.add(Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), trackCenter);
        newPosition = MinecraftRail.add(newPosition, MinecraftRail.scale(trackMovement, trackPosMotionInverted ? -distanceToCenter : distanceToCenter));
        newPosition = MinecraftRail.add(newPosition, MinecraftRail.scale(trackMovement, trackMotionInverted ? -motion.func_72433_c() : motion.func_72433_c()));
        return newPosition;
    }

    public static boolean isRail(World world, int posX, int posY, int posZ) {
        return world.func_147439_a(posX, posY, posZ) instanceof BlockRailBase;
    }

    static {
        Vec3 north = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
        Vec3 south = Vec3.func_72443_a((double)0.0, (double)0.0, (double)-1.0);
        Vec3 east = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
        Vec3 west = Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0);
        Vec3 ascending = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
        vectors.put(EnumRailDirection.ASCENDING_EAST, MinecraftRail.add(east, ascending).func_72432_b());
        vectors.put(EnumRailDirection.ASCENDING_NORTH, MinecraftRail.add(north, ascending).func_72432_b());
        vectors.put(EnumRailDirection.ASCENDING_SOUTH, MinecraftRail.add(south, ascending).func_72432_b());
        vectors.put(EnumRailDirection.ASCENDING_WEST, MinecraftRail.add(west, ascending).func_72432_b());
        vectors.put(EnumRailDirection.EAST_WEST, east.func_72432_b());
        vectors.put(EnumRailDirection.NORTH_EAST, MinecraftRail.add(north, east).func_72432_b());
        vectors.put(EnumRailDirection.NORTH_SOUTH, north.func_72432_b());
        vectors.put(EnumRailDirection.NORTH_WEST, MinecraftRail.add(north, west).func_72432_b());
        vectors.put(EnumRailDirection.SOUTH_EAST, MinecraftRail.add(south, east).func_72432_b());
        vectors.put(EnumRailDirection.SOUTH_WEST, MinecraftRail.add(south, west).func_72432_b());
        centers.put(EnumRailDirection.ASCENDING_EAST, Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
        centers.put(EnumRailDirection.ASCENDING_NORTH, Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
        centers.put(EnumRailDirection.ASCENDING_SOUTH, Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
        centers.put(EnumRailDirection.ASCENDING_WEST, Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
        centers.put(EnumRailDirection.EAST_WEST, Vec3.func_72443_a((double)0.5, (double)0.1, (double)0.5));
        centers.put(EnumRailDirection.NORTH_EAST, Vec3.func_72443_a((double)0.75, (double)0.1, (double)0.25));
        centers.put(EnumRailDirection.NORTH_SOUTH, Vec3.func_72443_a((double)0.5, (double)0.1, (double)0.5));
        centers.put(EnumRailDirection.NORTH_WEST, Vec3.func_72443_a((double)0.25, (double)0.1, (double)0.25));
        centers.put(EnumRailDirection.SOUTH_EAST, Vec3.func_72443_a((double)0.75, (double)0.1, (double)0.75));
        centers.put(EnumRailDirection.SOUTH_WEST, Vec3.func_72443_a((double)0.25, (double)0.1, (double)0.75));
    }

    public static enum EnumRailDirection {
        NORTH_SOUTH,
        EAST_WEST,
        ASCENDING_EAST,
        ASCENDING_WEST,
        ASCENDING_NORTH,
        ASCENDING_SOUTH,
        SOUTH_EAST,
        SOUTH_WEST,
        NORTH_WEST,
        NORTH_EAST;

    }
}

