/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.model;

import com.builtbroken.jlib.model.Face;
import com.builtbroken.jlib.model.Mesh;
import com.builtbroken.jlib.model.UVPoint;
import com.builtbroken.jlib.model.Vert;
import java.util.ArrayList;
import java.util.HashMap;

public class IcoSphereCreator {
    private static final HashMap<Integer, Mesh> SPHERE_CACHE = new HashMap();
    private Mesh geometry;
    private int index;
    private HashMap<Long, Integer> middlePointIndexCache;

    public static void init_cache() {
        SPHERE_CACHE.clear();
        for (int i = 0; i < 6; ++i) {
            IcoSphereCreator creator = new IcoSphereCreator();
            SPHERE_CACHE.put(i, creator.Create(i));
        }
    }

    public static Mesh create(int level) {
        return IcoSphereCreator.create(level, true);
    }

    public static Mesh create(int level, boolean cache) {
        if (!SPHERE_CACHE.containsKey(level) || SPHERE_CACHE.get(level) == null) {
            IcoSphereCreator creator = new IcoSphereCreator();
            if (cache) {
                SPHERE_CACHE.put(level, creator.Create(level));
            } else {
                return creator.Create(level);
            }
        }
        return SPHERE_CACHE.get(level).clone();
    }

    private int addVertex(Vert p) {
        double length = Math.sqrt(p.x() * p.x() + p.y() * p.y() + p.z() * p.z());
        this.geometry.addVert(new Vert(p.x() / length, p.y() / length, p.z() / length));
        return this.index++;
    }

    private int getMiddlePoint(int p1, int p2) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        if (this.middlePointIndexCache.containsKey(key)) {
            return this.middlePointIndexCache.get(key);
        }
        Vert point1 = this.geometry.getVertices().get(p1);
        Vert point2 = this.geometry.getVertices().get(p2);
        Vert middle = new Vert((point1.x() + point2.x()) / 2.0, (point1.y() + point2.y()) / 2.0, (point1.z() + point2.z()) / 2.0);
        int i = this.addVertex(middle);
        this.middlePointIndexCache.put(key, i);
        return i;
    }

    private Mesh Create(int recursionLevel) {
        this.geometry = new Mesh();
        this.middlePointIndexCache = new HashMap();
        this.index = 0;
        double t = (1.0 + Math.sqrt(5.0)) / 2.0;
        this.addVertex(new Vert(-1.0, t, 0.0));
        this.addVertex(new Vert(1.0, t, 0.0));
        this.addVertex(new Vert(-1.0, -t, 0.0));
        this.addVertex(new Vert(1.0, -t, 0.0));
        this.addVertex(new Vert(0.0, -1.0, t));
        this.addVertex(new Vert(0.0, 1.0, t));
        this.addVertex(new Vert(0.0, -1.0, -t));
        this.addVertex(new Vert(0.0, 1.0, -t));
        this.addVertex(new Vert(t, 0.0, -1.0));
        this.addVertex(new Vert(t, 0.0, 1.0));
        this.addVertex(new Vert(-t, 0.0, -1.0));
        this.addVertex(new Vert(-t, 0.0, 1.0));
        ArrayList<Face> faces = new ArrayList<Face>();
        faces.add(new Face(0, 11, 5));
        faces.add(new Face(0, 5, 1));
        faces.add(new Face(0, 1, 7));
        faces.add(new Face(0, 7, 10));
        faces.add(new Face(0, 10, 11));
        faces.add(new Face(1, 5, 9));
        faces.add(new Face(5, 11, 4));
        faces.add(new Face(11, 10, 2));
        faces.add(new Face(10, 7, 6));
        faces.add(new Face(7, 1, 8));
        faces.add(new Face(3, 9, 4));
        faces.add(new Face(3, 4, 2));
        faces.add(new Face(3, 2, 6));
        faces.add(new Face(3, 6, 8));
        faces.add(new Face(3, 8, 9));
        faces.add(new Face(4, 9, 5));
        faces.add(new Face(2, 4, 11));
        faces.add(new Face(6, 2, 10));
        faces.add(new Face(8, 6, 7));
        faces.add(new Face(9, 8, 1));
        for (int i = 0; i < recursionLevel; ++i) {
            ArrayList<Face> faces2 = new ArrayList<Face>();
            for (Face tri : faces) {
                int a = this.getMiddlePoint(tri.vertexIndices[0], tri.vertexIndices[1]);
                int b = this.getMiddlePoint(tri.vertexIndices[1], tri.vertexIndices[2]);
                int c = this.getMiddlePoint(tri.vertexIndices[2], tri.vertexIndices[0]);
                faces2.add(new Face(tri.vertexIndices[0], a, c));
                faces2.add(new Face(tri.vertexIndices[1], b, a));
                faces2.add(new Face(tri.vertexIndices[2], c, b));
                faces2.add(new Face(a, b, c));
            }
            faces = faces2;
        }
        this.geometry.getFaces().addAll(faces);
        this.geometry.textureCoordinates.add(new UVPoint(0.0, 0.0));
        this.geometry.textureCoordinates.add(new UVPoint(0.5, 1.0));
        this.geometry.textureCoordinates.add(new UVPoint(1.0, 0.0));
        for (Face face : this.geometry.getFaces()) {
            Vert v1 = this.geometry.getVertices().get(face.vertexIndices[0]);
            Vert v2 = this.geometry.getVertices().get(face.vertexIndices[1]);
            Vert v3 = this.geometry.getVertices().get(face.vertexIndices[2]);
            Vert u = (Vert)v2.sub(v1);
            Vert v = (Vert)v3.sub(v1);
            double x = u.y() * v.z() - u.z() * v.y();
            double y = u.z() * v.x() - u.x() * v.z();
            double z = u.x() * v.y() - u.y() * v.x();
            this.geometry.normals.add((Vert)new Vert(x, y, z).normalize());
            face.normalIndices[0] = this.geometry.normals.size() - 1;
            face.normalIndices[1] = this.geometry.normals.size() - 1;
            face.normalIndices[2] = this.geometry.normals.size() - 1;
            face.textureCoordinateIndices[0] = 0;
            face.textureCoordinateIndices[1] = 1;
            face.textureCoordinateIndices[2] = 2;
        }
        return this.geometry;
    }
}

