/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MathHelper {
    public static final Random rand = new Random();

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static double absCap(double value, double bounds) {
        return Math.min(Math.max(value, -bounds), bounds);
    }

    public static float absCap(float value, float bounds) {
        return Math.min(Math.max(value, -bounds), bounds);
    }

    public static short randomShort() {
        return (short)(rand.nextInt(65534) - Short.MAX_VALUE);
    }

    public static int[] generateRandomIntArray(Random random, int maxNumber, int arraySize) {
        return MathHelper.generateRandomIntArray(random, 0, maxNumber, arraySize);
    }

    public static int[] generateSqeuncedArray(int start, int size) {
        int[] array = new int[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = start + i;
        }
        return array;
    }

    public static List<Integer> getSquencedList(int start, int end, int ... ignore) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> remove = new ArrayList<Integer>();
        if (ignore != null & ignore.length > 0) {
            for (i = 0; i <= ignore.length; ++i) {
                remove.add(ignore[i]);
            }
        }
        for (i = 0; i <= end; ++i) {
            if (remove.contains(start + i)) continue;
            list.add(start + i);
        }
        return list;
    }

    public static int[] generateRandomIntArray(Random random, int minNumber, int maxNumber, int arraySize) {
        int[] array = new int[arraySize];
        for (int i = 0; i < array.length; ++i) {
            int number = random.nextInt(maxNumber);
            if (minNumber != 0) {
                while (number < minNumber) {
                    number = random.nextInt(maxNumber);
                }
            }
            array[i] = number;
        }
        return array;
    }

    public static float clampAngle(float var, float min, float max) {
        while (var < min) {
            var += 360.0f;
        }
        while (var > max) {
            var -= 360.0f;
        }
        return var;
    }

    public static double clampAngle(double var, double min, float max) {
        while (var < min) {
            var += (double)max;
        }
        while (var > (double)max) {
            var -= (double)max;
        }
        return var;
    }

    public static float clamp(float var, float min, float max) {
        if (var < min) {
            return min;
        }
        if (var > max) {
            return max;
        }
        return var;
    }

    public static double dclamp(double var, double min, double max) {
        if (var < min) {
            return min;
        }
        if (var > max) {
            return max;
        }
        return var;
    }

    public static float clampAngleTo360(float var) {
        return MathHelper.clampAngle(var, 0.0f, 360.0f);
    }

    public static double clampAngleTo360(double var) {
        return MathHelper.clampAngle(var, 0.0, 360.0f);
    }

    public static float clampAngleTo180(float var) {
        return MathHelper.clampAngle(var, -180.0f, 180.0f);
    }

    public static double clampAngleTo180(double var) {
        return MathHelper.clampAngle(var, -180.0, 180.0f);
    }

    public static float shortestAngleTo360(float angle, float angleGoal) {
        if ((angle = MathHelper.clampAngleTo360(angle)) == (angleGoal = MathHelper.clampAngleTo360(angleGoal))) {
            return 0.0f;
        }
        if (angle > angleGoal) {
            return angleGoal - angle;
        }
        return angle - angleGoal;
    }

    public static double getSphereVolume(double radius) {
        return Math.PI * 4 * (radius * radius * radius) / 3.0;
    }

    public static int func_154353_e(double p_154353_0_) {
        return (int)(p_154353_0_ >= 0.0 ? p_154353_0_ : -p_154353_0_ + 1.0);
    }
}

