/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.data.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.Pos2D;
import com.builtbroken.jlib.helpers.MathHelper;
import java.util.Random;

public abstract class Pos3D<R extends Pos3D>
extends Pos2D<R> {
    final double z;

    public Pos3D(double x, double y, double z) {
        super(x, y);
        this.z = z;
    }

    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public R addRandom(Random rand, double r) {
        double i = rand.nextDouble() * r - rand.nextDouble() * r;
        double j = rand.nextDouble() * r - rand.nextDouble() * r;
        double k = rand.nextDouble() * r - rand.nextDouble() * r;
        return this.newPos(i + this.x(), j + this.y(), k + this.z());
    }

    public R add(double x, double y, double z) {
        return this.newPos(x + this.x(), y + this.y(), z + this.z());
    }

    public R add(IPos3D other) {
        return this.add(other.x(), other.y(), other.z());
    }

    @Override
    public R add(double a) {
        return this.add(a, a, a);
    }

    public R sub(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public R subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public R sub(IPos3D other) {
        return this.sub(other.x(), other.y(), other.z());
    }

    public R subtract(IPos3D other) {
        return this.sub(other.x(), other.y(), other.z());
    }

    @Override
    public R sub(double a) {
        return this.sub(a, a, a);
    }

    public R subtract(double a) {
        return this.sub(a, a, a);
    }

    public double distance(IPos3D pos) {
        return ((Pos2D)this.sub(pos)).magnitude();
    }

    public double distance(double x, double y, double z) {
        return ((Pos2D)this.sub(x, y, z)).magnitude();
    }

    public R multiply(IPos3D other) {
        return this.multiply(other.x(), other.y(), other.z());
    }

    public R multiply(double x, double y, double z) {
        return this.newPos(x * this.x(), y * this.y(), z * this.z());
    }

    @Override
    public R multiply(double a) {
        return this.multiply(a, a, a);
    }

    public R divide(IPos3D other) {
        return this.divide(other.x(), other.y(), other.z());
    }

    public R divide(double x, double y, double z) {
        return this.newPos(this.x() / x, this.y() / y, this.z() / z);
    }

    @Override
    public R divide(double a) {
        return this.divide(a, a, a);
    }

    public R midpoint(IPos3D other) {
        return (R)((Pos3D)this.add(other)).divide(2.0);
    }

    public double dot(IPos3D other) {
        return this.dot(other.x(), other.y(), other.z());
    }

    public double dot(double x, double y, double z) {
        return this.x() * x + this.y() * y + this.z() * z;
    }

    public R cross(IPos3D other) {
        return this.newPos(other.x(), other.y(), other.z());
    }

    public R cross(double x, double y, double z) {
        return this.newPos(this.y() * z - z * y, z * x - this.x() * z, this.x() * y - this.y() * x);
    }

    public R lerp(IPos3D end, float percent) {
        return this.newPos(this.x() + (double)percent * (end.x() - this.x()), this.y() + (double)percent * (end.y() - this.y()), this.z() + (double)percent * (end.z() - this.z()));
    }

    @Override
    public R floor() {
        return this.newPos(Math.floor(this.x()), Math.floor(this.y()), Math.floor(this.z()));
    }

    public R Slerp(IPos3D end, float percent) {
        double dot = MathHelper.dclamp(this.dot(end), -1.0, 1.0);
        double theta = Math.acos(dot) * (double)percent;
        Pos3D relativeVec = (Pos3D)((Pos2D)this.newPos((end.x() - this.x()) * dot, (end.y() - this.y()) * dot, (end.z() - this.z()) * dot)).normalize();
        double x = this.x() * Math.cos(theta) + relativeVec.x() * Math.sin(theta);
        double y = this.y() * Math.cos(theta) + relativeVec.y() * Math.sin(theta);
        double z = this.z() * Math.cos(theta) + relativeVec.z() * Math.sin(theta);
        return this.newPos(x, y, z);
    }

    public R nlerp(IPos3D end, float percent) {
        return (R)((Pos3D)((Pos2D)this.lerp(end, percent)).normalize());
    }

    public R max(IPos3D other) {
        return this.newPos(Math.max(this.x(), other.x()), Math.max(this.y(), other.y()), Math.max(this.z(), other.z()));
    }

    public R min(IPos3D other) {
        return this.newPos(Math.min(this.x(), other.x()), Math.min(this.y(), other.y()), Math.max(this.z(), other.z()));
    }

    public R midPoint(IPos3D pos) {
        return this.newPos((this.x() + pos.x()) / 2.0, (this.y() + pos.y()) / 2.0, (this.z + pos.z()) / 2.0);
    }

    @Override
    public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0 && this.z() == 0.0;
    }

    @Override
    public double magnitudeSquared() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z();
    }

    public double z() {
        return this.z;
    }

    public float zf() {
        return (float)this.z;
    }

    public int zi() {
        return (int)Math.floor(this.z);
    }

    public R perpendicular() {
        if (this.z == 0.0) {
            return this.zCross();
        }
        return this.xCross();
    }

    public R xCross() {
        return this.newPos(0.0, this.z(), -this.y());
    }

    public R zCross() {
        return this.newPos(-this.y(), this.x(), 0.0);
    }

    @Override
    public R clone() {
        return this.newPos(this.x(), this.y(), this.z());
    }

    @Override
    public R newPos(double x, double y) {
        return this.newPos(x, y, this.z);
    }

    public abstract R newPos(double var1, double var3, double var5);

    @Override
    public int hashCode() {
        long x = Double.doubleToLongBits(this.x());
        long y = Double.doubleToLongBits(this.y());
        long z = Double.doubleToLongBits(this.z());
        long hash = x ^ x >>> 32;
        hash = 31L * hash + y ^ y >>> 32;
        hash = 31L * hash + z ^ z >>> 32;
        return (int)hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IPos3D) {
            return ((IPos3D)o).x() == this.x() && ((IPos3D)o).y() == this.y() && ((IPos3D)o).z() == this.z();
        }
        return false;
    }

    public int compare(IPos3D that) {
        if (this.x() < that.x() || this.y() < that.y() || this.z < that.z()) {
            return -1;
        }
        if (this.x() > that.x() || this.y() > that.y() || this.z > that.z()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Pos3D [" + this.x() + "," + this.y() + "," + this.z() + "]";
    }
}

