/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge;

import com.mitchej123.hodgepodge.config.PollutionRecolorConfig;
import com.mitchej123.hodgepodge.util.BlockMatcher;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public class LoadingConfig {
    private Configuration config;
    public BlockMatcher standardBlocks = new BlockMatcher();
    public BlockMatcher liquidBlocks = new BlockMatcher();
    public BlockMatcher doublePlants = new BlockMatcher();
    public BlockMatcher crossedSquares = new BlockMatcher();
    public BlockMatcher blockVine = new BlockMatcher();
    private static final String pollutionRecolorComment = "Blocks that should be colored by pollution. \n\tGrouped by the render type. \n\tFormat: [BlockClass]:[colortype] \n\tValid types: GRASS, LEAVES, FLOWER, LIQUID \n\tAdd [-] first to blacklist.";

    public LoadingConfig(File file) {
        this.config = new Configuration(file);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void postInitClient() {
        if (this.config == null) {
            System.err.println("Didn't load HODGEPODGE");
            this.config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        this.standardBlocks.updateClassList(PollutionRecolorConfig.renderStandardBlock);
        this.liquidBlocks.updateClassList(PollutionRecolorConfig.renderBlockLiquid);
        this.doublePlants.updateClassList(PollutionRecolorConfig.renderBlockDoublePlant);
        this.crossedSquares.updateClassList(PollutionRecolorConfig.renderCrossedSquares);
        this.blockVine.updateClassList(PollutionRecolorConfig.renderblockVine);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

