/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.redstoneflux;

import cofh.api.energy.IEnergyReceiver;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRedstoneFluxConsumer
extends TileEntityEnergyConsumer<IEnergyReceiver>
implements IEnergyReceiver {
    private double lastReceivedRF;

    public TileEntityRedstoneFluxConsumer() {
        super(PowerSystems.powerSystemRedstoneFlux, 0, IEnergyReceiver.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public double getInputRate() {
        double last = this.lastReceivedRF;
        this.lastReceivedRF = 0.0;
        return last;
    }

    public boolean canConnectEnergy(ForgeDirection arg0) {
        return !ConfigurationHandler.dissableRFConsumer;
    }

    public int getEnergyStored(ForgeDirection arg0) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)(bridge.getEnergyStored() / (double)this.getPowerSystem().getScaleAmmount());
    }

    public int getMaxEnergyStored(ForgeDirection arg0) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)(bridge.getEnergyStoredMax() / (double)this.getPowerSystem().getScaleAmmount());
    }

    public int receiveEnergy(ForgeDirection from, int receiveMax, boolean simulate) {
        if (this.getFirstBridge() == null) {
            return 0;
        }
        int actualRF = this.getPowerSystem().getScaleAmmount() * receiveMax;
        int rfNotStored = (int)((double)actualRF - this.storeEnergy(actualRF, simulate));
        return rfNotStored / this.getPowerSystem().getScaleAmmount();
    }
}

