/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.radarstation;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.hz.IItemFrequency;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Point;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.world.map.radar.RadarRegistry;
import com.builtbroken.mc.lib.world.map.radio.RadioRegistry;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.items.ItemBlockBase;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.registry.GameRegistry;
import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.prefab.TileFrequency;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileRadarStation
extends TileFrequency
implements IPacketIDReceiver,
IRadioWaveSender,
IRecipeContainer,
IGuiTile {
    public static final int MAX_DETECTION_RANGE = 500;
    public static final int GUI_PACKET_ID = 1;
    public static final int WATTS = 2;
    public float rotation = 0.0f;
    public int alarmRange = 100;
    public int safetyRange = 50;
    public boolean emitAll = true;
    public List<Entity> detectedEntities = new ArrayList<Entity>();
    private List<EntityMissile> incomingMissiles = new ArrayList<EntityMissile>();

    public TileRadarStation() {
        super("radarStation", Material.field_151573_f);
        this.itemBlock = ItemBlockBase.class;
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.isOpaque = false;
        this.renderTileEntity = true;
        this.renderNormalBlock = false;
        this.canEmmitRedstone = true;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    public Tile newTile() {
        return new TileRadarStation();
    }

    public void firstTick() {
        super.firstTick();
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void update() {
        super.update();
        if (!this.field_145850_b.field_72995_K && this.ticks % 40L == 0L) {
            this.sendDescPacket();
        }
        if (this.hasEnergy()) {
            this.rotation += 0.08f;
            if (this.rotation > 360.0f) {
                this.rotation = 0.0f;
            }
            if (!this.field_145850_b.field_72995_K) {
                // empty if block
            }
            int prevDetectedEntities = this.detectedEntities.size();
            if (this.isServer()) {
                this.doScan();
            }
            if (prevDetectedEntities != this.detectedEntities.size()) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            if (this.ticks % 20L == 0L && this.incomingMissiles.size() > 0) {
                RadioRegistry.popMessage((World)this.oldWorld(), (IRadioWaveSender)this, (float)this.getFrequency(), (String)"fireAntiMissile", (Object[])new Object[]{this.incomingMissiles.get(0)});
            }
        } else {
            if (this.detectedEntities.size() > 0) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            this.incomingMissiles.clear();
            this.detectedEntities.clear();
        }
        if (this.ticks % 40L == 0L) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    private boolean hasEnergy() {
        return true;
    }

    private void doScan() {
        int i;
        this.incomingMissiles.clear();
        this.detectedEntities.clear();
        List entities = RadarRegistry.getAllLivingObjectsWithin((World)this.oldWorld(), (double)((double)this.xi() + 1.5), (double)((double)this.yi() + 0.5), (double)((double)this.zi() + 0.5), (double)500.0, null);
        block0: for (Entity entity : entities) {
            if (entity instanceof EntityMissile) {
                if (((EntityMissile)entity).getTicksInAir() <= -1) continue;
                if (!this.detectedEntities.contains(entity)) {
                    this.detectedEntities.add(entity);
                }
                if (!this.isMissileGoingToHit((EntityMissile)entity)) continue;
                if (this.incomingMissiles.size() > 0) {
                    double dist = new Pos((TileEntity)this).distance((IPos3D)new Pos(entity));
                    for (i = 0; i < this.incomingMissiles.size(); ++i) {
                        EntityMissile daoDan = this.incomingMissiles.get(i);
                        Pos pos = new Pos((TileEntity)this);
                        if (dist < pos.distance((IPos3D)daoDan.toPos())) {
                            this.incomingMissiles.add(i, (EntityMissile)entity);
                            continue block0;
                        }
                        if (i != this.incomingMissiles.size() - 1) continue;
                        this.incomingMissiles.add((EntityMissile)entity);
                        continue block0;
                    }
                    continue;
                }
                this.incomingMissiles.add((EntityMissile)entity);
                continue;
            }
            this.detectedEntities.add(entity);
        }
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 500), (double)(this.field_145848_d - 500), (double)(this.field_145849_e - 500), (double)(this.field_145851_c + 500), (double)(this.field_145848_d + 500), (double)(this.field_145849_e + 500)));
        for (EntityPlayer player : players) {
            if (player == null) continue;
            boolean youHuoLuan = false;
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IItemFrequency)) continue;
                youHuoLuan = true;
                break;
            }
            if (youHuoLuan) continue;
            this.detectedEntities.add((Entity)player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMissileGoingToHit(EntityMissile missile) {
        if (missile == null) return false;
        if (missile.targetVector == null) {
            return false;
        }
        Point point = new Point((double)this.field_145851_c, (double)this.field_145849_e);
        if (!(missile.toPos().toVector2().distance((IPos2D)point) < (double)this.alarmRange)) return false;
        Point point2 = new Point((double)this.field_145851_c, (double)this.field_145849_e);
        if (!(missile.targetVector.toVector2().distance((IPos2D)point2) < (double)this.safetyRange)) return false;
        return true;
    }

    @Override
    protected PacketTile getGUIPacket() {
        PacketTile packet = new PacketTile((TileEntity)this, new Object[]{1, this.alarmRange, this.safetyRange, this.getFrequency()});
        packet.write((Object)this.detectedEntities.size());
        if (this.detectedEntities.size() > 0) {
            for (Entity entity : this.detectedEntities) {
                if (entity != null && entity.func_70089_S()) {
                    packet.write((Object)entity.func_145782_y());
                    continue;
                }
                packet.write((Object)-1);
            }
        }
        return packet;
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.setEnergy(buf.readInt());
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.getEnergy());
    }

    public boolean read(ByteBuf data, int ID, EntityPlayer player, PacketType type) {
        if (!super.read(data, ID, player, type)) {
            if (this.field_145850_b.field_72995_K) {
                if (ID == 1) {
                    this.alarmRange = data.readInt();
                    this.safetyRange = data.readInt();
                    this.setFrequency(data.readInt());
                    this.detectedEntities.clear();
                    int entityListSize = data.readInt();
                    for (int i = 0; i < entityListSize; ++i) {
                        Entity entity;
                        int id = data.readInt();
                        if (id == -1 || (entity = this.oldWorld().func_73045_a(id)) == null) continue;
                        this.detectedEntities.add(entity);
                    }
                    return true;
                }
            } else if (!this.field_145850_b.field_72995_K) {
                if (ID == 2) {
                    this.safetyRange = data.readInt();
                    return true;
                }
                if (ID == 3) {
                    this.alarmRange = data.readInt();
                    return true;
                }
                if (ID == 4) {
                    this.setFrequency(data.readInt());
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public int getStrongRedstonePower(int side) {
        if (this.incomingMissiles.size() > 0) {
            if (this.emitAll) {
                return Math.min(15, 5 + this.incomingMissiles.size());
            }
            for (EntityMissile incomingMissile : this.incomingMissiles) {
                Point position = incomingMissile.toPos().toVector2();
                ForgeDirection missileTravelDirection = ForgeDirection.UNKNOWN;
                double closest = -1.0;
                for (int i = 2; i < 6; ++i) {
                    double dist = position.distance((IPos2D)new Point((double)(this.field_145851_c + ForgeDirection.getOrientation((int)i).offsetX), (double)(this.field_145849_e + ForgeDirection.getOrientation((int)i).offsetZ)));
                    if (!(dist < closest) && !(closest < 0.0)) continue;
                    missileTravelDirection = ForgeDirection.getOrientation((int)i);
                    closest = dist;
                }
                if (missileTravelDirection.getOpposite().ordinal() != side) continue;
                return Math.min(15, 5 + this.incomingMissiles.size());
            }
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.safetyRange = nbt.func_74762_e("safetyBanJing");
        this.alarmRange = nbt.func_74762_e("alarmBanJing");
        this.emitAll = nbt.func_74767_n("emitAll");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("safetyBanJing", this.safetyRange);
        nbt.func_74768_a("alarmBanJing", this.alarmRange);
        nbt.func_74757_a("emitAll", this.emitAll);
    }

    protected boolean onPlayerRightClick(EntityPlayer entityPlayer, int side, Pos hit) {
        if (entityPlayer.field_71071_by.func_70448_g() != null && WrenchUtility.isUsableWrench((EntityPlayer)entityPlayer, (ItemStack)entityPlayer.field_71071_by.func_70448_g(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)) {
            if (!this.field_145850_b.field_72995_K) {
                this.emitAll = !this.emitAll;
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"message.radar.redstone") + " " + this.emitAll));
            }
            return true;
        }
        if (this.isServer()) {
            entityPlayer.openGui((Object)ICBMClassic.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public void sendRadioMessage(float hz, String header, Object ... data) {
        RadioRegistry.popMessage((World)this.oldWorld(), (IRadioWaveSender)this, (float)hz, (String)header, (Object[])data);
    }

    public Cube getRadioSenderRange() {
        return null;
    }

    public void genRecipes(List<IRecipe> recipes) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockRadarStation), new Object[]{"?@?", " ! ", "!#!", Character.valueOf('@'), new ItemStack(ICBMClassic.itemRadarGun), Character.valueOf('!'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('?'), Items.field_151043_k}));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy(player, (Object)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }
}

