/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.ex;

import com.builtbroken.mc.lib.render.model.loader.EngineModelLoader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.Explosive;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;

public abstract class Explosion
extends Explosive {
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation resourceLocation;
    @SideOnly(value=Side.CLIENT)
    private IModelCustom model;
    public String missileModelPath;

    public Explosion(String name, int tier) {
        super(name, tier);
    }

    public void launch(EntityMissile missileObj) {
    }

    public void update(EntityMissile missileObj) {
    }

    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer) {
        return false;
    }

    public boolean isCruise() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getMissileResource() {
        if (this.resourceLocation == null) {
            this.resourceLocation = new ResourceLocation("icbmclassic", "textures/models/missile_" + this.getUnlocalizedName() + ".png");
        }
        return this.resourceLocation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getMissileModel() {
        if (this.missileModelPath != null) {
            try {
                if (this.model == null) {
                    this.model = EngineModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbmclassic", "models/" + this.missileModelPath));
                }
            }
            catch (Exception e) {
                ICBMClassic.INSTANCE.logger().error("Unexpected error while loading missile Model[ " + this.missileModelPath + "]", (Throwable)e);
            }
            return this.model;
        }
        return null;
    }
}

