/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.Location;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.prefab.ModelICBM;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import resonant.api.explosion.ExplosionEvent;
import resonant.api.explosion.IExplosion;

public abstract class Blast
extends Explosion
implements IExplosion,
IWorldPosition {
    public Location position;
    public EntityExplosion controller = null;
    public boolean isAlive = true;
    protected int callCount = 0;

    public Blast(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.position = new Location(world, x, y, z);
    }

    public Blast(Location pos, Entity entity, float size) {
        super(pos.oldWorld(), entity, pos.x(), pos.y(), pos.z(), size);
        this.position = pos;
    }

    public Blast(Entity entity, float size) {
        super(entity.field_70170_p, entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, size);
        this.position = new Location(entity);
    }

    protected void doPreExplode() {
    }

    public final void preExplode() {
        ExplosionEvent.PreExplosionEvent evt = new ExplosionEvent.PreExplosionEvent(this.oldWorld(), (IExplosion)this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPreExplode();
        }
    }

    protected abstract void doExplode();

    public final void onExplode() {
        ExplosionEvent.DoExplosionEvent evt = new ExplosionEvent.DoExplosionEvent(this.oldWorld(), (IExplosion)this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doExplode();
            ++this.callCount;
        }
    }

    protected void doPostExplode() {
    }

    public final void postExplode() {
        ExplosionEvent.PostExplosionEvent evt = new ExplosionEvent.PostExplosionEvent(this.oldWorld(), (IExplosion)this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPostExplode();
        }
    }

    public void onPositionUpdate(double posX, double posY, double posZ) {
        this.field_77284_b = posX;
        this.field_77285_c = posY;
        this.field_77282_d = posZ;
        this.position = new Location(this.oldWorld(), posX, posY, posZ);
    }

    public void func_77278_a() {
    }

    public void func_77279_a(boolean par1) {
    }

    public void explode() {
        ExplosionEvent.ExplosionConstructionEvent evt = new ExplosionEvent.ExplosionConstructionEvent(this.oldWorld(), (IExplosion)this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            if (this.proceduralInterval() > 0) {
                if (!this.oldWorld().field_72995_K) {
                    this.oldWorld().func_72838_d((Entity)new EntityExplosion(this));
                }
            } else {
                this.doPreExplode();
                this.doExplode();
                this.doPostExplode();
            }
        }
    }

    public int countIncrement() {
        return 1;
    }

    public float getRadius() {
        return this.field_77280_f;
    }

    public long getEnergy() {
        return 0L;
    }

    public int proceduralInterval() {
        return -1;
    }

    protected void doDamageEntities(float radius, float power) {
        this.doDamageEntities(radius, power, true);
    }

    protected void doDamageEntities(float radius, float power, boolean destroyItem) {
        Location minCoord = (Location)this.position.add((double)(-(radius *= 2.0f) - 1.0f));
        Location maxCoord = (Location)this.position.add((double)(radius + 1.0f));
        List allEntities = this.oldWorld().func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)minCoord.xi(), (double)minCoord.yi(), (double)minCoord.zi(), (double)maxCoord.xi(), (double)maxCoord.yi(), (double)maxCoord.zi()));
        Vec3 var31 = Vec3.func_72443_a((double)this.position.x(), (double)this.position.y(), (double)this.position.z());
        for (int i = 0; i < allEntities.size(); ++i) {
            double distance;
            Entity entity = (Entity)allEntities.get(i);
            if (this.onDamageEntity(entity)) continue;
            if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).setExplode();
                continue;
            }
            if (entity instanceof EntityItem && !destroyItem || !((distance = entity.func_70011_f(this.position.x(), this.position.y(), this.position.z()) / (double)radius) <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.position.x();
            double yDifference = entity.field_70163_u - this.position.y();
            double zDifference = entity.field_70161_v - this.position.z();
            double var35 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= var35;
            yDifference /= var35;
            zDifference /= var35;
            double var34 = this.oldWorld().func_72842_a(var31, entity.field_70121_D);
            double var36 = (1.0 - distance) * var34;
            int damage = 0;
            damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)power + 1.0);
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
            entity.field_70159_w += xDifference * var36;
            entity.field_70181_x += yDifference * var36;
            entity.field_70179_y += zDifference * var36;
        }
    }

    protected boolean onDamageEntity(Entity entity) {
        return false;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.callCount = nbt.func_74762_e("callCount");
        this.field_77280_f = nbt.func_74760_g("explosionSize");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("callCount", this.callCount);
        nbt.func_74776_a("explosionSize", this.field_77280_f);
    }

    public boolean isMovable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelICBM getRenderModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getRenderResource() {
        return null;
    }

    public World oldWorld() {
        return this.position.oldWorld();
    }

    public double x() {
        return this.position.x();
    }

    public double y() {
        return this.position.y();
    }

    public double z() {
        return this.position.z();
    }
}

