/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive;

import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.ex.ExAntiGravitational;
import icbm.classic.content.explosive.ex.ExAntimatter;
import icbm.classic.content.explosive.ex.ExBreaching;
import icbm.classic.content.explosive.ex.ExChemical;
import icbm.classic.content.explosive.ex.ExCondensed;
import icbm.classic.content.explosive.ex.ExDebilitation;
import icbm.classic.content.explosive.ex.ExEMP;
import icbm.classic.content.explosive.ex.ExEnder;
import icbm.classic.content.explosive.ex.ExEndothermic;
import icbm.classic.content.explosive.ex.ExExothermic;
import icbm.classic.content.explosive.ex.ExIncendiary;
import icbm.classic.content.explosive.ex.ExNightmare;
import icbm.classic.content.explosive.ex.ExNuclear;
import icbm.classic.content.explosive.ex.ExRedMatter;
import icbm.classic.content.explosive.ex.ExRejuvenation;
import icbm.classic.content.explosive.ex.ExRepulsive;
import icbm.classic.content.explosive.ex.ExSMine;
import icbm.classic.content.explosive.ex.ExShrapnel;
import icbm.classic.content.explosive.ex.ExSonic;
import icbm.classic.content.explosive.ex.missiles.Missile;
import icbm.classic.content.explosive.ex.missiles.MissileAnti;
import icbm.classic.content.explosive.ex.missiles.MissileCluster;
import icbm.classic.content.explosive.ex.missiles.MissileHoming;
import icbm.classic.content.explosive.ex.missiles.MissileModule;
import icbm.classic.content.explosive.ex.missiles.MissileNuclearCluster;
import net.minecraft.item.ItemStack;

public enum Explosives {
    CONDENSED(new ExCondensed("condensed", 1)),
    SHRAPNEL(new ExShrapnel("shrapnel", 1)),
    INCENDIARY(new ExIncendiary("incendiary", 1)),
    DEBLITATION(new ExDebilitation("debilitation", 1)),
    CHEMICAL(new ExChemical("chemical", 1)),
    ANVIL(new ExShrapnel("anvil", 1)),
    REPLUSIVE(new ExRepulsive("repulsive", 1)),
    ATTRACTIVE(new ExRepulsive("attractive", 1)),
    FRAGMENTATION(new ExShrapnel("fragmentation", 2)),
    CONTAGIOUS(new ExChemical("contagious", 2)),
    SONIC(new ExSonic("sonic", 2)),
    BREACHING(new ExBreaching()),
    REJUVENATION(new ExRejuvenation()),
    THERMOBARIC(new ExNuclear("thermobaric", 2)),
    SMINE(new ExSMine("sMine", 2)),
    NUCLEAR(new ExNuclear("nuclear", 3)),
    EMP(new ExEMP()),
    EXOTHERMIC(new ExExothermic()),
    ENDOTHERMIC(new ExEndothermic()),
    ANTI_GRAV(new ExAntiGravitational()),
    ENDER(new ExEnder()),
    HYPERSONIC(new ExSonic("hypersonic", 3)),
    ANTIMATTER(new ExAntimatter()),
    REDMATTER(new ExRedMatter()),
    MISSILE(new MissileModule()),
    MISSILE_HOMING(new MissileHoming()),
    MISSILE_ANTI(new MissileAnti()),
    MISSILE_CLUSTER(new MissileCluster("cluster", 2)),
    MISSILE_CLUSTER_NUKE(new MissileNuclearCluster()),
    NIGHTMARE(new ExNightmare());

    public final Explosive handler;

    private Explosives(Explosive handler) {
        this.handler = handler;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        if (this.handler instanceof Missile) {
            return new ItemStack(ICBMClassic.itemMissile, amount, this.ordinal());
        }
        return new ItemStack(ICBMClassic.blockExplosive, amount, this.ordinal());
    }

    public static Explosives get(int itemDamage) {
        if (itemDamage >= 0 && itemDamage < Explosives.values().length) {
            return Explosives.values()[itemDamage];
        }
        return CONDENSED;
    }
}

