/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.blast.Blast;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityExplosion
extends Entity
implements IEntityAdditionalSpawnData {
    private Blast blast;
    private double blastYOffset = 0.0;
    private boolean endExplosion = false;

    public EntityExplosion(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70145_X = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70155_l = 2.0;
        this.field_70158_ak = true;
        this.field_70173_aa = 0;
    }

    public EntityExplosion(Blast blast) {
        this(blast.oldWorld());
        this.setBlast(blast);
    }

    public String func_70005_c_() {
        return "Explosion[" + (Object)((Object)this.blast) + "]";
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70014_b(nbt);
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.func_70037_a(ByteBufUtils.readTag((ByteBuf)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        if (this.getBlast() == null || this.getBlast().controller != this || !this.getBlast().isAlive) {
            this.func_70106_y();
            ICBMClassic.INSTANCE.logger().error("Procedural explosion ended due to null! This is a bug!");
            return;
        }
        if (this.getBlast().isMovable() && (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0)) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.getBlast().onPositionUpdate(this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v);
        }
        if (this.field_70173_aa == 1) {
            this.getBlast().preExplode();
        } else if (this.field_70173_aa % this.getBlast().proceduralInterval() == 0) {
            if (!this.endExplosion) {
                this.getBlast().onExplode();
            } else {
                this.getBlast().postExplode();
                this.func_70106_y();
            }
        }
    }

    public void endExplosion() {
        this.endExplosion = true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        try {
            NBTTagCompound blastSave = nbt.func_74775_l("blast");
            this.blastYOffset = nbt.func_74769_h("blastPosY");
            if (this.getBlast() == null) {
                Class<?> clazz = Class.forName(blastSave.func_74779_i("class"));
                Constructor<?> constructor = clazz.getConstructor(World.class, Entity.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE);
                this.setBlast((Blast)((Object)constructor.newInstance(this.field_70170_p, null, this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v, 0)));
            }
            this.getBlast().readFromNBT(blastSave);
        }
        catch (Exception e) {
            ICBMClassic.INSTANCE.logger().error("ICBM error in loading an explosion!");
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("blastPosY", this.blastYOffset);
        NBTTagCompound baoZhaNBT = new NBTTagCompound();
        baoZhaNBT.func_74778_a("class", ((Object)((Object)this.getBlast())).getClass().getCanonicalName());
        this.getBlast().writeToNBT(baoZhaNBT);
        nbt.func_74782_a("blast", (NBTBase)baoZhaNBT);
    }

    public Blast getBlast() {
        return this.blast;
    }

    public void setBlast(Blast blast) {
        this.blast = blast;
        if (blast != null) {
            this.blast.controller = this;
            this.func_70107_b(blast.position.x(), !blast.isMovable() ? -1.0 : blast.y(), blast.position.z());
            this.blastYOffset = blast.isMovable() ? 0.0 : blast.y() + 1.0;
        }
    }
}

