/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render.tile;

import com.builtbroken.mc.lib.render.RenderUtility;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.ICBMClassic;
import icbm.classic.client.models.ModelSMine;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBombBlock
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    public static final ResourceLocation TEXTURE_FILE = new ResourceLocation("icbmclassic", "textures/models/s-mine.png");
    public static final int ID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == ID) {
            if (metadata == Explosives.SMINE.ordinal()) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_FILE);
                ModelSMine.INSTANCE.render(0.0625f);
                GL11.glPopMatrix();
            } else {
                try {
                    RenderUtility.renderNormalBlockAsItem((Block)block, (int)metadata, (RenderBlocks)renderer);
                }
                catch (Exception e) {
                    ICBMClassic.INSTANCE.logger().error("ICBM Explosive Rendering Crash with: " + block + " and metadata: " + metadata);
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        Explosive explosive;
        TileEntity tileEntity;
        if (modelID == ID && (tileEntity = iBlockAccess.func_147438_o(x, y, z)) instanceof TileEntityExplosive && ((explosive = ((TileEntityExplosive)tileEntity).explosive.handler).getBlockModel() == null || explosive.getBlockResource() == null)) {
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        Explosive explosive;
        if (tileEntity instanceof TileEntityExplosive && (explosive = ((TileEntityExplosive)tileEntity).explosive.handler) != null && explosive.getBlockModel() != null && explosive.getBlockResource() != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(explosive.getBlockResource());
            explosive.getBlockModel().render(0.0625f);
            RenderUtility.setTerrainTexture();
            GL11.glPopMatrix();
        }
    }

    public int getRenderId() {
        return ID;
    }
}

