/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.TwilightForestMod;
import twilightforest.block.StepSoundTFInsect;
import twilightforest.item.TFItems;

public abstract class BlockTFCritter
extends Block {
    protected BlockTFCritter() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.func_149647_a(TFItems.creativeTab);
        this.field_149762_H = new StepSoundTFInsect("squish", 0.25f, 0.6f);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int facing = world.func_72805_g(x, y, z) & 7;
        float wide = 0.15f;
        switch (facing) {
            case 1: {
                this.func_149676_a(0.0f, 0.2f, 0.5f - wide, wide * 2.0f, 0.8f, 0.5f + wide);
                break;
            }
            case 2: {
                this.func_149676_a(1.0f - wide * 2.0f, 0.2f, 0.5f - wide, 1.0f, 0.8f, 0.5f + wide);
                break;
            }
            case 3: {
                this.func_149676_a(0.5f - wide, 0.2f, 0.0f, 0.5f + wide, 0.8f, wide * 2.0f);
                break;
            }
            case 4: {
                this.func_149676_a(0.5f - wide, 0.2f, 1.0f - wide * 2.0f, 0.5f + wide, 0.8f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.5f - wide, 0.0f, 0.2f, 0.5f + wide, wide * 2.0f, 0.8f);
                break;
            }
            case 6: {
                this.func_149676_a(0.5f - wide, 1.0f - wide * 2.0f, 0.2f, 0.5f + wide, 1.0f, 0.8f);
                break;
            }
            default: {
                float f1 = 0.1f;
                this.func_149676_a(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return TwilightForestMod.proxy.getCritterBlockRenderID();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (this.canPlaceAt(world, x - 1, y, z)) {
            return true;
        }
        if (this.canPlaceAt(world, x + 1, y, z)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y, z - 1)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y, z + 1)) {
            return true;
        }
        if (this.canPlaceAt(world, x, y - 1, z)) {
            return true;
        }
        return this.canPlaceAt(world, x, y + 1, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int placementFacing, float par6, float par7, float par8, int meta) {
        switch (placementFacing) {
            case 0: {
                if (!this.canPlaceAt(world, x, y + 1, z)) break;
                meta = 6;
                break;
            }
            case 1: {
                if (!this.canPlaceAt(world, x, y - 1, z)) break;
                meta = 5;
                break;
            }
            case 2: {
                if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) break;
                meta = 4;
                break;
            }
            case 3: {
                if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) break;
                meta = 3;
                break;
            }
            case 4: {
                if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) break;
                meta = 2;
                break;
            }
            case 5: {
                if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) break;
                meta = 1;
            }
        }
        return meta;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0) {
            if (this.canPlaceAt(world, x - 1, y, z)) {
                world.func_72921_c(x, y, z, 1, 2);
            } else if (this.canPlaceAt(world, x + 1, y, z)) {
                world.func_72921_c(x, y, z, 2, 2);
            } else if (this.canPlaceAt(world, x, y, z - 1)) {
                world.func_72921_c(x, y, z, 3, 2);
            } else if (this.canPlaceAt(world, x, y, z + 1)) {
                world.func_72921_c(x, y, z, 4, 2);
            } else if (this.canPlaceAt(world, x, y - 1, z)) {
                world.func_72921_c(x, y, z, 5, 2);
            } else if (this.canPlaceAt(world, x, y + 1, z)) {
                world.func_72921_c(x, y, z, 6, 2);
            }
        }
        this.dropCritterIfCantStay(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public boolean dropCritterIfCantStay(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockID) {
        if (this.dropCritterIfCantStay(world, x, y, z)) {
            int facing = world.func_72805_g(x, y, z) & 7;
            boolean flag = false;
            switch (facing) {
                case 1: {
                    if (this.canPlaceAt(world, x - 1, y, z)) break;
                    flag = true;
                    break;
                }
                case 2: {
                    if (this.canPlaceAt(world, x + 1, y, z)) break;
                    flag = true;
                    break;
                }
                case 3: {
                    if (this.canPlaceAt(world, x, y, z - 1)) break;
                    flag = true;
                    break;
                }
                case 4: {
                    if (this.canPlaceAt(world, x, y, z + 1)) break;
                    flag = true;
                    break;
                }
                case 5: {
                    if (this.canPlaceAt(world, x, y - 1, z)) break;
                    flag = true;
                    break;
                }
                case 6: {
                    if (this.canPlaceAt(world, x, y + 1, z)) break;
                    flag = true;
                }
            }
            if (flag) {
                this.func_149697_b(world, x, y, z, 0, 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public boolean canPlaceAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Material blockMaterial = block.func_149688_o();
        return block.isNormalCube((IBlockAccess)world, x, y, z) || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151570_A;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        itemList.add(new ItemStack(item, 1, 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("TwilightForest:" + this.func_149739_a().substring(5));
    }
}

