/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.DeviceCodeFlow;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.AbstractScreen;
import technicianlp.reauth.session.SessionHelper;

public final class FlowScreen
extends AbstractScreen
implements FlowCallback {
    private Flow flow;
    private FlowStage stage = FlowStage.INITIAL;
    private String[] formatArgs = new String[0];

    public static <F extends Flow, P> F open(BiFunction<P, FlowCallback, F> flowConstructor, P param, GuiScreen background) {
        Flow flow;
        FlowScreen screen = new FlowScreen(background);
        screen.flow = flow = (Flow)flowConstructor.apply(param, screen);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
        return (F)flow;
    }

    private FlowScreen(GuiScreen background) {
        super("reauth.gui.title.flow", background);
    }

    @Override
    public final void func_73866_w_() {
        DeviceCodeFlow flow;
        super.func_73866_w_();
        int buttonWidth = 196;
        int buttonWidthH = buttonWidth / 2;
        this.formatArgs = new String[0];
        if (this.stage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            this.getClass();
            this.field_146292_n.add(new GuiButton(2, this.centerX - buttonWidthH, this.baseY + 175 - 42, buttonWidth, 20, I18n.func_135052_a((String)"reauth.msauth.button.browser", (Object[])new Object[0])));
        } else if (this.stage == FlowStage.MS_POLL_DEVICE_CODE && this.flow instanceof DeviceCodeFlow && CompletableFuture.allOf((flow = (DeviceCodeFlow)this.flow).getLoginUrl(), flow.getCode()).isDone()) {
            this.getClass();
            this.field_146292_n.add(new GuiButton(3, this.centerX - buttonWidthH, this.baseY + 175 - 42, buttonWidth, 20, I18n.func_135052_a((String)"reauth.msauth.button.browser", (Object[])new Object[0])));
            this.formatArgs = new String[]{flow.getLoginUrl().join(), flow.getCode().join()};
        }
    }

    @Override
    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = I18n.func_135052_a((String)this.stage.getRawName(), (Object[])this.formatArgs);
        String[] lines = text.split("\\\\n");
        int height = lines.length * 9;
        for (String s : lines) {
            if (!s.startsWith("$")) continue;
            height += 9;
        }
        int y = this.centerY - height / 2;
        for (String line : lines) {
            if (line.startsWith("$")) {
                line = line.substring(1);
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                this.field_146289_q.func_78261_a(line, (this.centerX - this.field_146289_q.func_78256_a(line)) / 2, y / 2, -1);
                y += 18;
                GL11.glPopMatrix();
                continue;
            }
            this.field_146289_q.func_78261_a(line, this.centerX - this.field_146289_q.func_78256_a(line) / 2, y, -1);
            y += 9;
        }
    }

    @Override
    public final void func_146281_b() {
        super.func_146281_b();
        if (this.stage != FlowStage.FINISHED) {
            this.flow.cancel();
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        CompletableFuture<String> loginUrl;
        super.func_146284_a(button);
        String uriString = null;
        if (button.field_146127_k == 2 && this.flow instanceof AuthorizationCodeFlow) {
            uriString = ((AuthorizationCodeFlow)this.flow).getLoginUrl();
        } else if (button.field_146127_k == 3 && this.flow instanceof DeviceCodeFlow && (loginUrl = ((DeviceCodeFlow)this.flow).getLoginUrl()).isDone()) {
            uriString = loginUrl.join();
        }
        if (uriString != null) {
            try {
                URI uri = new URI(uriString);
                this.openLink(uri);
            }
            catch (URISyntaxException e) {
                ReAuth.log.error("Browser button failed", (Throwable)e);
            }
        }
    }

    @Override
    public void onSessionComplete(SessionData session, Throwable throwable) {
        if (throwable == null) {
            SessionHelper.setSession(session);
            ReAuth.log.info("Login complete");
        } else if (throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException) {
            ReAuth.log.info("Login cancelled");
        } else {
            ReAuth.log.error("Login failed", throwable);
        }
    }

    @Override
    public void onProfileComplete(Profile profile, Throwable throwable) {
        if (throwable == null) {
            ReAuth.profiles.storeProfile(profile);
            ReAuth.log.info("Profile saved successfully");
        } else if (throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException) {
            ReAuth.log.info("Profile saving cancelled");
        } else {
            ReAuth.log.error("Profile failed to save", throwable);
        }
    }

    @Override
    public final void transitionStage(FlowStage newStage) {
        this.stage = newStage;
        ReAuth.log.info(this.stage.getLogLine());
        this.func_146280_a(Minecraft.func_71410_x(), this.field_146294_l, this.field_146295_m);
        if (newStage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            try {
                URI uri = new URI(((AuthorizationCodeFlow)this.flow).getLoginUrl());
                this.openLink(uri);
            }
            catch (URISyntaxException e) {
                ReAuth.log.error("Failed to open page", (Throwable)e);
            }
        } else if (newStage == FlowStage.FINISHED) {
            this.requestClose(true);
        }
    }

    @Override
    public final Executor getExecutor() {
        return ReAuth.executor;
    }

    private void openLink(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable throwable) {
            ReAuth.log.error("Couldn't open link", throwable);
        }
    }
}

