/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Session;
import net.minecraftforge.client.event.GuiScreenEvent;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReconnectHelper;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.MainScreen;
import technicianlp.reauth.session.SessionChecker;
import technicianlp.reauth.session.SessionStatus;
import technicianlp.reauth.util.ReflectionUtils;

public final class EventHandler {
    private static final Field disconnectReason = ReflectionUtils.findObfuscatedField(GuiDisconnected.class, "field_146306_a", "reason");
    private static final Field disconnectMessage = ReflectionUtils.findObfuscatedField(GuiDisconnected.class, "field_146304_f", "message");

    @SubscribeEvent
    public final void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen screen = event.gui;
        if (screen instanceof GuiMultiplayer) {
            event.buttonList.add(new GuiButton(17325, 5, 5, 100, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0])));
        } else if (screen instanceof GuiMainMenu) {
            event.buttonList.add(new GuiButton(17325, -50, -50, 20, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0])));
        } else if (screen instanceof GuiDisconnected) {
            this.handleDisconnectScreen(event, screen);
        } else if (screen instanceof GuiConnecting) {
            ReconnectHelper.setConnectScreen((GuiConnecting)screen);
        }
    }

    private void handleDisconnectScreen(GuiScreenEvent.InitGuiEvent.Post event, GuiScreen screen) {
        if (I18n.func_135052_a((String)"connect.failed", (Object[])new Object[0]).equals(ReflectionUtils.getField(disconnectReason, screen)) && ReconnectHelper.getTranslationKey((IChatComponent)ReflectionUtils.getField(disconnectMessage, screen)).startsWith("disconnect.loginFailed")) {
            GuiButton menu = (GuiButton)event.buttonList.get(0);
            Profile profile = ReAuth.profiles.getProfile();
            String retryText = profile != null ? I18n.func_135052_a((String)"reauth.retry", (Object[])new Object[]{profile.getValue("name", "Steve")}) : I18n.func_135052_a((String)"reauth.retry.disabled", (Object[])new Object[0]);
            GuiButton retryButton = new GuiButton(17325, menu.field_146128_h, menu.field_146129_i + 25, 200, 20, retryText);
            if (profile == null || !ReconnectHelper.hasConnectionInfo()) {
                retryButton.field_146124_l = false;
            }
            event.buttonList.add(retryButton);
        }
    }

    @SubscribeEvent
    public final void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (e.gui instanceof GuiMultiplayer) {
            Session user = Minecraft.func_71410_x().func_110432_I();
            SessionStatus state = SessionChecker.getSessionStatus(user.func_148254_d(), user.func_148255_b());
            Minecraft.func_71410_x().field_71466_p.func_78261_a(I18n.func_135052_a((String)state.getTranslationKey(), (Object[])new Object[0]), 110, 10, -1);
        }
    }

    @SubscribeEvent
    public final void action(GuiScreenEvent.ActionPerformedEvent.Post e) {
        Profile profile;
        GuiScreen screen = e.gui;
        if ((screen instanceof GuiMainMenu || screen instanceof GuiMultiplayer) && e.button.field_146127_k == 17325) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((GuiScreen)new MainScreen(mc.field_71462_r));
        } else if (screen instanceof GuiDisconnected && e.button.field_146127_k == 17325 && (profile = ReAuth.profiles.getProfile()) != null) {
            ReconnectHelper.retryLogin(profile);
        }
    }

    @SubscribeEvent
    public final void action(GuiScreenEvent.ActionPerformedEvent.Pre e) {
        if (e.gui instanceof GuiMultiplayer && e.button.field_146127_k == 8 && GuiScreen.func_146272_n()) {
            SessionChecker.invalidate();
        }
    }
}

