/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.magicalcrops;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.magicalcrops.CommonProxy;
import powercrystals.minefactoryreloaded.modhelpers.magicalcrops.Harvestable;

@Mod(modid="MineFactoryReloaded|CompatMagicalCrops", name="MFR Compat: MagicalCrops", version="1.2.4", dependencies="after:MineFactoryReloaded;after:magicalcrops")
public class MagicalCrops {
    @SidedProxy(clientSide="powercrystals.minefactoryreloaded.modhelpers.magicalcrops.CommonProxy", serverSide="powercrystals.minefactoryreloaded.modhelpers.magicalcrops.ServerProxy")
    public static CommonProxy proxy;

    @NetworkCheckHandler
    public boolean checkModeLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    public static void load() {
        if (!Loader.isModLoaded((String)"magicalcrops")) {
            FMLLog.info((String)"Magical Crops not founded!", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> MSeeds = Class.forName("com.mark719.magicalcrops.handlers.MSeeds");
            Class<?> MCrops = Class.forName("com.mark719.magicalcrops.handlers.MCrops");
            FMLLog.info((String)"Registering Magical Crops for Planter/Harvester/Fertilizer", (Object[])new Object[0]);
            Field[] hSeeds = MSeeds.getFields();
            Field[] hCrops = MCrops.getFields();
            ArrayList<ItemSeeds> Seeds = new ArrayList<ItemSeeds>();
            ArrayList<BlockBush> Crops = new ArrayList<BlockBush>();
            FMLLog.info((String)"%d Seeds founded!", (Object[])new Object[]{hSeeds.length});
            int i = 0;
            while (i < hSeeds.length) {
                if (hSeeds[i].get(null) instanceof Item) {
                    Seeds.add((ItemSeeds)hSeeds[i].get(null));
                }
                ++i;
            }
            i = 0;
            while (i < hCrops.length) {
                if (hCrops[i].get(null) instanceof Block) {
                    Crops.add((BlockBush)hCrops[i].get(null));
                }
                ++i;
            }
            i = 0;
            while (i < Seeds.size()) {
                FMLLog.info((String)"Added %s to MFR!", (Object[])new Object[]{((ItemSeeds)Seeds.get(i)).toString()});
                FMLLog.info((String)"Added %s to MFR!", (Object[])new Object[]{((BlockBush)Crops.get(i)).toString()});
                MFRRegistry.registerPlantable((IFactoryPlantable)new PlantableCropPlant((Item)Seeds.get(i), ((ItemSeeds)Seeds.get(i)).getPlant(null, 0, 0, 0)));
                MFRRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable((ItemSeeds)Seeds.get(i)));
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            FMLLog.warning((String)"Unable to load support for Magical Crops", (Object[])new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadModCompat() {
        if (!Loader.isModLoaded((String)"magicalcrops")) {
            FMLLog.info((String)"Magical Crops not founded!", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> MModCompat = Class.forName("com.mark719.magicalcrops.handlers.ModCompat");
            FMLLog.info((String)"Registering Magical Crops ModCompat for Planter/Harvester/Fertilizer", (Object[])new Object[0]);
            Field[] hModCompat = MModCompat.getFields();
            ArrayList<ItemSeeds> Seeds = new ArrayList<ItemSeeds>();
            ArrayList<BlockBush> Crops = new ArrayList<BlockBush>();
            int i = 0;
            while (i < hModCompat.length) {
                if (hModCompat[i].get(null) instanceof ItemSeeds && hModCompat[i].get(null) != null) {
                    Seeds.add((ItemSeeds)hModCompat[i].get(null));
                } else if (hModCompat[i].get(null) instanceof BlockBush && hModCompat[i].get(null) != null) {
                    Crops.add((BlockBush)hModCompat[i].get(null));
                }
                ++i;
            }
            FMLLog.info((String)"Seeds %d founded!", (Object[])new Object[]{Seeds.size()});
            i = 0;
            while (i < Seeds.size()) {
                FMLLog.info((String)"Added %s to MFR!", (Object[])new Object[]{((ItemSeeds)Seeds.get(i)).toString()});
                FMLLog.info((String)"Added %s to MFR!", (Object[])new Object[]{((BlockBush)Crops.get(i)).toString()});
                MFRRegistry.registerPlantable((IFactoryPlantable)new PlantableCropPlant((Item)Seeds.get(i), ((ItemSeeds)Seeds.get(i)).getPlant(null, 0, 0, 0)));
                MFRRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable((ItemSeeds)Seeds.get(i)));
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            FMLLog.warning((String)"Unable to load support for Magical Crops", (Object[])new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

