/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureUtils;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class Canvas9Seg {
    public final ResourceLocation tex;
    public float[] seg_u = new float[4];
    public float[] seg_v = new float[4];
    public int[] seg_w = new int[3];
    public int[] seg_h = new int[3];

    public Canvas9Seg(ResourceLocation tex) {
        this.tex = tex;
        this.load();
    }

    private int[] readMarkers(TextureDataHolder data, int stride, int size) {
        int[] markers = new int[4];
        int marker = 1;
        int prev_col = data.data[0];
        for (int i = 1; i < size; ++i) {
            if (data.data[i * stride] == prev_col) continue;
            markers[marker] = i;
            prev_col = data.data[i * stride];
            if (++marker == 4) break;
        }
        markers[0] = markers[0] + 1;
        markers[3] = markers[3] - 1;
        return markers;
    }

    private void parseMarkers(TextureDataHolder data, int stride, int size, int[] sizes, float[] texcoords) {
        int[] markers = this.readMarkers(data, stride, size);
        for (int i = 0; i < 4; ++i) {
            texcoords[i] = (float)markers[i] / (float)size;
            if (i <= 0) continue;
            sizes[i - 1] = markers[i] - markers[i - 1];
        }
    }

    private void load() {
        TextureDataHolder data = TextureUtils.loadTexture(this.tex);
        this.parseMarkers(data, 1, data.width, this.seg_w, this.seg_u);
        this.parseMarkers(data, data.width, data.height, this.seg_h, this.seg_v);
    }

    private void drawSeg(int[] sw, int[] sh, int seg) {
        Tessellator t = Tessellator.field_78398_a;
        int u = seg % 3;
        int v = seg / 3;
        t.func_78374_a((double)sw[u], (double)sh[v], 0.0, (double)this.seg_u[u], (double)this.seg_v[v]);
        t.func_78374_a((double)sw[u], (double)sh[v + 1], 0.0, (double)this.seg_u[u], (double)this.seg_v[v + 1]);
        t.func_78374_a((double)sw[u + 1], (double)sh[v + 1], 0.0, (double)this.seg_u[u + 1], (double)this.seg_v[v + 1]);
        t.func_78374_a((double)sw[u + 1], (double)sh[v], 0.0, (double)this.seg_u[u + 1], (double)this.seg_v[v]);
    }

    public void draw(CCRenderState state, int x, int y, int w, int h) {
        CCRenderState.changeTexture(this.tex);
        state.reset();
        state.startDrawing();
        int[] sw = new int[]{x, x + this.seg_w[0], x + w - this.seg_w[2], x + w};
        int[] sh = new int[]{y, y + this.seg_h[0], y + h - this.seg_h[2], y + h};
        for (int seg = 0; seg < 9; ++seg) {
            this.drawSeg(sw, sh, seg);
        }
        state.draw();
    }

    public void draw(int x, int y, int w, int h) {
        this.draw(CCRenderState.instance(), x, y, w, h);
    }
}

