/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.testing.tile;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.tile.BlockTile;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.testing.junit.ModRegistry;
import com.builtbroken.mc.testing.junit.icons.SudoIconReg;
import com.builtbroken.mc.testing.junit.server.FakeDedicatedServer;
import com.builtbroken.mc.testing.junit.testers.TestPlayer;
import com.builtbroken.mc.testing.junit.world.FakeWorld;
import com.builtbroken.mc.testing.junit.world.FakeWorldServer;
import com.builtbroken.mc.testing.tile.AbstractTileEntityTest;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import org.junit.Test;

public abstract class AbstractTileTest<T extends Tile>
extends AbstractTileEntityTest<T, BlockTile> {
    protected MinecraftServer server;
    protected FakeWorldServer world;
    protected TestPlayer player;
    protected boolean autoPlaceBlock = false;

    public AbstractTileTest(String name, Class<T> clazz) throws IllegalAccessException, InstantiationException {
        name = LanguageUtility.capitalizeFirst(name);
        this.tileClazz = clazz;
        Tile tile = (Tile)clazz.newInstance();
        BlockTile block = new BlockTile(tile, "Block" + name, CreativeTabs.field_78027_g);
        tile.setBlock(block);
        this.block = ModRegistry.registerBlock((Block)block, (String)("Block" + name));
        TileEntity.func_145826_a((Class)this.tileClazz, (String)("Tile" + name));
    }

    @Override
    public void setUpForEntireClass() {
        super.setUpForEntireClass();
        this.server = new FakeDedicatedServer(new File(FakeWorldServer.baseFolder, this.tileClazz.getName()));
        this.world = FakeWorldServer.newWorld((MinecraftServer)this.server, (String)this.tileClazz.getName());
        this.player = new TestPlayer(this.server, (WorldServer)this.world, new GameProfile(null, "TileTester"));
    }

    public void setUpForTest(String name) {
        super.setUpForTest(name);
        this.player.reset();
        this.world.func_147449_b(0, 0, 0, this.block);
    }

    public void tearDownForTest(String name) {
        super.tearDownForTest(name);
        this.world.func_147468_f(0, 0, 0);
        this.world.func_72835_b();
        AbstractTileTest.assertTrue((String)"Block at [0,0,0] should be air after test is finished", (this.world.func_147439_a(0, 0, 0) == Blocks.field_150350_a ? 1 : 0) != 0);
    }

    @Test
    public void testX() {
        FakeWorld world = FakeWorld.newWorld((String)"TestX");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145851_c == (int)((Tile)tile).x() ? 1 : 0) != 0);
    }

    @Test
    public void testY() {
        FakeWorld world = FakeWorld.newWorld((String)"TestY");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145848_d == (int)((Tile)tile).y() ? 1 : 0) != 0);
    }

    @Test
    public void testZ() {
        FakeWorld world = FakeWorld.newWorld((String)"TestZ");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145849_e == (int)((Tile)tile).z() ? 1 : 0) != 0);
    }

    @Test
    public void testXi() {
        FakeWorld world = FakeWorld.newWorld((String)"TestXi");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145851_c == ((Tile)tile).xi() ? 1 : 0) != 0);
    }

    @Test
    public void testYi() {
        FakeWorld world = FakeWorld.newWorld((String)"TestYi");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145848_d == ((Tile)tile).yi() ? 1 : 0) != 0);
    }

    @Test
    public void testZi() {
        FakeWorld world = FakeWorld.newWorld((String)"TestZi");
        world.func_147449_b(0, 0, 0, this.block);
        TileEntity tile = world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getClass() == this.tileClazz ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((tile.field_145849_e == ((Tile)tile).zi() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() {
        FakeWorld world = FakeWorld.newWorld((String)"TestUpdate");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (int i = 0; i < 100; ++i) {
            tile.ticks = i;
            tile.update();
        }
    }

    @Override
    @Test
    public void testUpdateEntity() {
        FakeWorld world = FakeWorld.newWorld((String)"testUpdateEntity");
        world.func_147449_b(10, 11, 12, this.block);
        Tile tile = (Tile)world.func_147438_o(10, 11, 12);
        for (int i = 0; i < 1000; ++i) {
            AbstractTileTest.assertTrue((tile.ticks == (long)i ? 1 : 0) != 0);
            tile.func_145845_h();
        }
    }

    @Test
    public void testWorld() {
        FakeWorld world = FakeWorld.newWorld((String)"TestWorld");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.oldWorld() == world ? 1 : 0) != 0);
    }

    @Test
    public void testOnPlayerLeftClick() {
        this.world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)this.world.func_147438_o(0, 0, 0);
        tile.onPlayerLeftClick((EntityPlayer)this.player);
    }

    @Test
    public void testDoUpdateGuiUsers() {
        FakeWorld world = FakeWorld.newWorld((String)"TestDoUpdateGuiUsers");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.doUpdateGuiUsers();
    }

    @Test
    public void testDoCleanupCheck() {
        FakeWorld world = FakeWorld.newWorld((String)"TestDoCleanupCheck");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.doCleanupCheck();
    }

    @Test
    public void testOnPlayerActivated() {
        this.world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)this.world.func_147438_o(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            for (int i = 0; i <= 256; ++i) {
                tile.onPlayerActivated((EntityPlayer)this.player, dir.ordinal(), this.getNextClick(dir, i));
            }
        }
    }

    protected Pos getNextClick(ForgeDirection dir, int index) {
        double i = (double)index / 256.0;
        double k = (double)index % 256.0;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                return new Pos(i, k, 0.0);
            }
            case EAST: 
            case WEST: {
                return new Pos(0.0, i, k);
            }
            case UP: 
            case DOWN: {
                return new Pos(i, 0.0, k);
            }
        }
        return null;
    }

    @Test
    public void testOnPlayerRightClick() {
        this.world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)this.world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("onPlayerRightClick", EntityPlayer.class, Integer.TYPE, Pos.class);
            method.setAccessible(true);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                for (int i = 0; i <= 256; ++i) {
                    method.invoke((Object)tile, new Object[]{this.player, dir.ordinal(), this.getNextClick(dir, i)});
                }
            }
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method onPlayerRightClick");
        }
        catch (InvocationTargetException e) {
            AbstractTileTest.fail((String)"Failed to invoke method onPlayerRightClick");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method onPlayerRightClick");
        }
    }

    @Test
    public void testOnPlayerRightClickWrench() {
        this.world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)this.world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("onPlayerRightClickWrench", EntityPlayer.class, Integer.TYPE, Pos.class);
            method.setAccessible(true);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                for (int i = 0; i <= 256; ++i) {
                    method.invoke((Object)tile, new Object[]{this.player, dir.ordinal(), this.getNextClick(dir, i)});
                }
            }
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method onPlayerRightClickWrench");
        }
        catch (InvocationTargetException e) {
            AbstractTileTest.fail((String)"Failed to invoke method onPlayerRightClickWrench");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method onPlayerRightClickWrench");
        }
    }

    @Test
    public void testQuantityDropped() {
        FakeWorld world = FakeWorld.newWorld((String)"TestQuantityDropped");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).quantityDropped(0, 0);
    }

    @Test
    public void testMetadataDropped() {
        FakeWorld world = FakeWorld.newWorld((String)"TestMetadataDropped");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).metadataDropped(0, 0);
    }

    @Test
    public void testOnClientRegistered() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnClientRegistered");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).onClientRegistered();
    }

    @Test
    public void testOnWorldSeparate() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnWorldSeparate");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).onWorldSeparate();
    }

    @Test
    public void testOnDestroyedByExplosion() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnDestroyedByExplosion");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).onDestroyedByExplosion(new Explosion((World)world, null, 0.0, 0.0, 0.0, 10.0f));
    }

    @Test
    public void testOnNeighborChanged() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnNeighborChanged");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).onNeighborChanged(this.block);
    }

    @Test
    public void testGetTextureName() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetTextureName");
        world.func_147449_b(0, 0, 0, this.block);
        try {
            Method method = Tile.class.getDeclaredMethod("getTextureName", new Class[0]);
            method.setAccessible(true);
            Tile tile = (Tile)world.func_147438_o(0, 0, 0);
            AbstractTileTest.assertTrue((method.invoke((Object)tile, new Object[0]) != null ? 1 : 0) != 0);
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method getTextureName");
        }
        catch (InvocationTargetException e) {
            AbstractTileTest.fail((String)"Failed to invoke method getTextureName");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method getTextureName");
        }
    }

    @Test
    public void testGetStrongestIndirectpower() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetStrongestIndirectpower");
        world.func_147449_b(0, 0, 0, this.block);
        ((Tile)world.func_147438_o(0, 0, 0)).getStrongestIndirectPower();
    }

    @Test
    public void testGetSelectBounds() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetSelectBounds");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        Cube cube = tile.getSelectBounds();
        AbstractTileTest.assertTrue((cube != null ? 1 : 0) != 0);
    }

    @Test
    public void testSetBlockBoundsBasedOnState() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetBlockBoundsBasedOnState");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setBlockBoundsBasedOnState();
    }

    @Test
    public void testSetTextureName() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetTextureName");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setTextureName("texture");
    }

    @Override
    @Test
    public void testGetBlockMetadata() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetBlockMetadata");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.func_145832_p();
    }

    @Test
    public void testCanSilkHarvest() {
        FakeWorld world = FakeWorld.newWorld((String)"TestCanSilkHarvest");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.canSilkHarvest((EntityPlayer)this.player, 0);
    }

    @Test
    public void testShouldSideBeRendered() {
        FakeWorld world = FakeWorld.newWorld((String)"TestShouldSideBeRendered");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            tile.shouldSideBeRendered(i);
        }
    }

    @Test
    public void testGetCollisionBounds() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetCollisionBounds");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        Cube cube = tile.getCollisionBounds();
        if (cube != null) {
            // empty if block
        }
    }

    @Test
    public void testGetWeakRedstonepower() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetWeakRedstonepower");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            tile.getWeakRedstonePower(i);
        }
    }

    @Test
    public void testGetRenderBlockpass() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetRenderBlockpass");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getRenderBlockPass();
    }

    @Test
    public void testGetRenderColor() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetRenderColor");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getRenderColor(0);
    }

    @Test
    public void testDetermineOrientation() {
        FakeWorld world = FakeWorld.newWorld((String)"TestDetermineOrientation");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.determineOrientation((EntityLivingBase)this.player);
    }

    @Test
    public void testGetplayersUsing() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetplayersUsing");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getPlayersUsing();
    }

    @Test
    public void testRemoveByplayer() {
        FakeWorld world = FakeWorld.newWorld((String)"TestRemoveByplayer");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.removeByPlayer((EntityPlayer)this.player, true);
        world.func_147449_b(0, 0, 0, this.block);
        tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.removeByPlayer((EntityPlayer)this.player, false);
    }

    @Test
    public void testNotifyBlocksOfNeighborChange() {
        FakeWorld world = FakeWorld.newWorld((String)"TestNotifyBlocksOfNeighborChange");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.notifyBlocksOfNeighborChange();
    }

    @Test
    public void testGetExplosionResistance() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetExplosionResistance");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getExplosionResistance((Entity)this.player);
        world.func_147449_b(0, 0, 0, this.block);
        tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getExplosionResistance((Entity)this.player, new Pos(2.0));
    }

    @Test
    public void testSendDescpacket() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSendDescpacket");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        if (tile.getDescPacket() != null) {
            // empty if block
        }
    }

    @Test
    public void testSendpacketToServer() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSendpacketToServer");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.sendPacketToServer(new PacketTile(tile, new Object[0]));
    }

    @Test
    public void testGetColorMultiplier() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetColorMultiplier");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getColorMultiplier();
    }

    @Test
    public void testGetCollisionBoxes() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetCollisionBoxes");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        Iterable<Cube> cubes = tile.getCollisionBoxes(new Cube(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0), (Entity)this.player);
        AbstractTileTest.assertTrue((cubes != null ? 1 : 0) != 0);
        for (Cube cube : cubes) {
            AbstractTileTest.assertTrue((cube != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSendPacketToGuiUsers() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSendpacketToGuiUsers");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.sendPacketToGuiUsers(new PacketTile(tile, new Object[0]));
    }

    @Test
    public void testDetermineForgeDirection() {
        FakeWorld world = FakeWorld.newWorld((String)"TestDetermineForgeDirection");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.determineForgeDirection((EntityLivingBase)this.player);
    }

    @Test
    public void testGetStrongRedstonePower() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetStrongRedstonepower");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            tile.getStrongRedstonePower(i);
        }
    }

    @Test
    public void testCanPlaceBlockAt() {
        FakeWorld world = FakeWorld.newWorld((String)"TestCanplaceBlockAt");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.canPlaceBlockAt();
    }

    @Test
    public void testCanPlaceBlockOnSide() {
        FakeWorld world = FakeWorld.newWorld((String)"TestCanplaceBlockOnSide");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            tile.canPlaceBlockOnSide(dir);
        }
    }

    @Test
    public void testRandomDisplayTick() {
        FakeWorld world = FakeWorld.newWorld((String)"TestRandomDisplayTick");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.randomDisplayTick();
    }

    @Test
    public void testRegisterSideTextureSet() {
        FakeWorld world = FakeWorld.newWorld((String)"TestRegisterSideTextureSet");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        SudoIconReg reg = new SudoIconReg();
        tile.registerSideTextureSet((IIconRegister)reg);
    }

    @Test
    public void testGetOwnerProfile() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetOwnerprofile");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getOwnerProfile();
    }

    @Test
    public void testGetSpecialRenderer() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetSpecialRenderer");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getSpecialRenderer();
    }

    @Test
    public void testIsIndirectlypowered() {
        FakeWorld world = FakeWorld.newWorld((String)"TestIsIndirectlypowered");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.isIndirectlyPowered();
    }

    @Test
    public void testHasSpecialRenderer() {
        FakeWorld world = FakeWorld.newWorld((String)"TestHasSpecialRenderer");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.hasSpecialRenderer();
    }

    @Test
    public void testNewTile() {
        FakeWorld world = FakeWorld.newWorld((String)"TestNewTile");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.newTile();
    }

    @Test
    public void testGetSubBlocks() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetSubBlocks");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        ArrayList list = new ArrayList();
        tile.getSubBlocks(Item.func_150898_a((Block)this.block), ((BlockTile)this.block).func_149708_J(), list);
        for (ItemStack stack : list) {
            AbstractTileTest.assertTrue((stack != null ? 1 : 0) != 0);
            AbstractTileTest.assertTrue((stack.func_77973_b() != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testToPos() {
        FakeWorld world = FakeWorld.newWorld((String)"TestTopos");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        Pos pos = tile.toPos();
        Pos pos2 = new Pos(tile.x(), tile.y(), tile.z());
        AbstractTileTest.assertTrue((String)("Pos " + (Object)((Object)pos) + " does not equal " + (Object)((Object)pos2)), (boolean)pos.equals((Object)pos2));
    }

    @Test
    public void testGetDrops() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetDrops");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        ArrayList<ItemStack> items = tile.getDrops(0, 0);
        for (ItemStack stack : items) {
            AbstractTileTest.assertTrue((stack != null ? 1 : 0) != 0);
            AbstractTileTest.assertTrue((stack.func_77973_b() != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOnWorldJoin() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnWorldJoin");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onWorldJoin();
    }

    @Test
    public void testOnPlaced() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnplaced");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onPlaced((EntityLivingBase)this.player, new ItemStack(this.block));
    }

    @Test
    public void testOnPostplaced() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnpostplaced");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onPostPlaced(0);
    }

    @Test
    public void testOnRemove() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnRemove");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onRemove(this.block, 0);
    }

    @Test
    public void testGetTileBlock() {
        AbstractTileTest.assertTrue((((BlockTile)this.block).staticTile.getTileBlock() == this.block ? 1 : 0) != 0);
    }

    @Test
    public void testOpenGui() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOpenGui");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.openGui((EntityPlayer)this.player, 0, Engine.loaderInstance);
    }

    @Test
    public void testOnAdded() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnAdded");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onAdded();
    }

    @Test
    public void testToItemStack() {
        FakeWorld world = FakeWorld.newWorld((String)"TestToItemStack");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        ItemStack stack = tile.toItemStack();
    }

    @Test
    public void testOnCollide() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnCollide");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onCollide((Entity)this.player);
    }

    @Test
    public void testGetAccess() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetAccess");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        AbstractTileTest.assertTrue((tile.getAccess() == world ? 1 : 0) != 0);
    }

    @Test
    public void testSetAccess() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetAccess");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setAccess((IBlockAccess)world);
    }

    @Test
    public void testGetpickBlock() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetpickBlock");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            for (int i = 0; i < 256; ++i) {
                tile.getPickBlock(new MovingObjectPosition(0, 0, 0, dir.ordinal(), this.getNextClick(dir, i).toVec3(), true));
            }
        }
    }

    @Test
    public void testToLocation() {
        FakeWorld world = FakeWorld.newWorld((String)"TestToLocation");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        Location loc = tile.toLocation();
        AbstractTileTest.assertTrue((loc.world == world ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((loc.xi() == tile.field_145851_c ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((loc.yi() == tile.field_145848_d ? 1 : 0) != 0);
        AbstractTileTest.assertTrue((loc.zi() == tile.field_145849_e ? 1 : 0) != 0);
    }

    @Test
    public void testOnRegistered() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnRegistered");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onRegistered();
    }

    @Test
    public void testBlockUpdate() {
        FakeWorld world = FakeWorld.newWorld((String)"TestBlockUpdate");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.blockUpdate();
    }

    @Test
    public void testFirstTick() {
        FakeWorld world = FakeWorld.newWorld((String)"TestFirstTick");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.firstTick();
    }

    @Test
    public void testGetBlockColor() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetBlockColor");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getBlockColor();
    }

    @Test
    public void testGetSideIcon() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetSideIcon");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.registerIcons((IIconRegister)new SudoIconReg());
        try {
            Method method = Tile.class.getDeclaredMethod("getSideIcon", Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            for (int i = 0; i < 6; ++i) {
                method.invoke((Object)tile, 0, i);
            }
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method getTextureName");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            AbstractTileTest.fail((String)"Failed to invoke method getTextureName");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method getTextureName");
        }
    }

    @Test
    public void testGetOwnerID() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetOwnerID");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getOwnerID();
    }

    @Test
    public void testDistance() {
        FakeWorld world = FakeWorld.newWorld((String)"TestDistance");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Pos pos = (Pos)((Object)new Pos(0.5).add(dir));
            Pos center = tile.toPos();
            double distance = tile.distance(pos.x(), pos.y(), pos.z());
            AbstractTileTest.assertTrue((String)("Distance = " + distance + "  Pos = " + (Object)((Object)pos) + "  Center = " + (Object)((Object)center)), (Math.abs(distance - 1.0) <= 0.01 ? 1 : 0) != 0);
            this.player.func_70012_b(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
            distance = tile.distance((Entity)this.player);
            AbstractTileTest.assertTrue((String)("Distance = " + distance + "  Pos = " + (Object)((Object)pos) + "  Center = " + (Object)((Object)center)), (Math.abs(distance - 1.0) <= 0.01 ? 1 : 0) != 0);
            distance = tile.distance(pos);
            AbstractTileTest.assertTrue((String)("Distance = " + distance + "  Pos = " + (Object)((Object)pos) + "  Center = " + (Object)((Object)center)), (Math.abs(distance - 1.0) <= 0.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleTick() {
        FakeWorld world = FakeWorld.newWorld((String)"TestScheduleTick");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("scheduleTick", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)tile, 0);
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method scheduleTick");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            AbstractTileTest.fail((String)"Failed to invoke method scheduleTick");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method scheduleTick");
        }
    }

    @Test
    public void testGetSaveData() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetSaveData");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        NBTTagCompound tag = tile.getSaveData();
        AbstractTileTest.assertTrue((tag != null && !tag.func_82582_d() ? 1 : 0) != 0);
    }

    @Test
    public void testIsClient() {
        FakeWorld world = FakeWorld.newWorld((String)"TestIsClient");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.isClient();
    }

    @Test
    public void testSetOwner() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetOwner");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setOwner((EntityPlayer)this.player);
    }

    @Test
    public void testSetMeta() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetMeta");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setMeta(10);
    }

    @Test
    public void testRegisterIcons() {
        FakeWorld world = FakeWorld.newWorld((String)"TestRegisterIcons");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.registerIcons((IIconRegister)new SudoIconReg());
    }

    @Test
    public void testSetOwnerID() {
        FakeWorld world = FakeWorld.newWorld((String)"TestSetOwnerID");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.setOwnerID(this.player.func_146103_bH().getId());
    }

    @Test
    public void testGetDescpacket() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetDescpacket");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getDescPacket();
    }

    @Test
    public void testUpdateLight() {
        FakeWorld world = FakeWorld.newWorld((String)"TestUpdateLight");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("updateLight", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)tile, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method updateLight");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            AbstractTileTest.fail((String)"Failed to invoke method updateLight");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method updateLight");
        }
    }

    @Test
    public void testGetIcon() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetIcon");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.registerIcons((IIconRegister)new SudoIconReg());
        tile.getIcon();
        for (int i = 0; i < 6; ++i) {
            tile.getIcon(i);
            tile.getIcon(i, 0);
        }
        tile.getIcon(tile.name);
    }

    @Test
    public void testOnFillRain() {
        FakeWorld world = FakeWorld.newWorld((String)"TestOnFillRain");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.onFillRain();
    }

    @Test
    public void testGetOwnerName() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetOwnerName");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getOwnerName();
    }

    @Test
    public void testMarkUpdate() {
        FakeWorld world = FakeWorld.newWorld((String)"TestMarkUpdate");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("markUpdate", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)tile, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method markUpdate");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            AbstractTileTest.fail((String)"Failed to invoke method markUpdate");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method markUpdate");
        }
    }

    @Test
    public void testMarkRender() {
        FakeWorld world = FakeWorld.newWorld((String)"TestMarkRender");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        try {
            Method method = Tile.class.getDeclaredMethod("markRender", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)tile, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            AbstractTileTest.fail((String)"Could not find method markRender");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            AbstractTileTest.fail((String)"Failed to invoke method markRender");
        }
        catch (IllegalAccessException e) {
            AbstractTileTest.fail((String)"Couldn't access method markRender");
        }
    }

    @Test
    public void testIsServer() {
        FakeWorld world = FakeWorld.newWorld((String)"TestIsServer");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.isServer();
    }

    @Test
    public void testGetLightValue() {
        FakeWorld world = FakeWorld.newWorld((String)"TestGetLightValue");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.getLightValue();
    }

    @Test
    public void testIsSolid() {
        FakeWorld world = FakeWorld.newWorld((String)"TestIsSolid");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            tile.isSolid(i);
        }
    }

    @Test
    public void testTickRate() {
        FakeWorld world = FakeWorld.newWorld((String)"TestTickRate");
        world.func_147449_b(0, 0, 0, this.block);
        Tile tile = (Tile)world.func_147438_o(0, 0, 0);
        tile.tickRate();
    }
}

