/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.world;

import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.IJsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.block.meta.MetaData;
import com.builtbroken.mc.seven.framework.json.world.JsonWorldOreGenData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class JsonWorldOreGenProcessor
extends JsonProcessor<JsonWorldOreGenData>
implements IJsonBlockSubProcessor {
    public JsonWorldOreGenProcessor() {
        super(JsonWorldOreGenData.class);
    }

    @Override
    public JsonWorldOreGenData process(JsonElement element) {
        return this.process(null, -1, null, element);
    }

    public JsonWorldOreGenData process(Block block, int meta, String ore, JsonElement element) {
        Object oreBlock;
        JsonObject genData = element.getAsJsonObject();
        JsonWorldOreGenProcessor.ensureValuesExist(genData, "minY", "maxY", "branchSize", "chunkLimit");
        if (block == null) {
            JsonWorldOreGenProcessor.ensureValuesExist(genData, "block");
            oreBlock = JsonWorldOreGenProcessor.getItemFromJson(genData.get("block"));
        } else {
            oreBlock = new ItemStack(block, 1, meta >= 0 ? meta : 0);
        }
        String oreName = ore;
        if (oreName == null) {
            JsonWorldOreGenProcessor.ensureValuesExist(genData, "oreName");
            oreName = genData.getAsJsonPrimitive("oreName").getAsString();
        }
        int min = genData.getAsJsonPrimitive("minY").getAsInt();
        int max = genData.getAsJsonPrimitive("maxY").getAsInt();
        int branch = genData.getAsJsonPrimitive("branchSize").getAsInt();
        int chunk = genData.getAsJsonPrimitive("chunkLimit").getAsInt();
        if (min > 255 || min < 0 || max > 255 || max < 0 || max < min) {
            throw new RuntimeException("Min & Max value for ore generators must be between 0-255, and max must be equal to or greater than min");
        }
        if (branch <= 0 || chunk <= 0) {
            throw new RuntimeException("Branch size per generation and chunk generation limit must be greater than zero.");
        }
        JsonWorldOreGenData data = new JsonWorldOreGenData(this, oreBlock, oreName, min, max, branch, chunk);
        this.processAdditionalKeys(data, genData);
        return data;
    }

    @Override
    public void process(BlockBase block, JsonElement element, List<IJsonGenObject> objectList) {
        JsonWorldOreGenData object = this.process((Block)block, 0, block.data.oreName, element);
        if (object != null) {
            objectList.add(object);
        }
    }

    @Override
    public void process(MetaData data, BlockBase block, JsonElement element, List<IJsonGenObject> objectList) {
        JsonWorldOreGenData object = this.process((Block)block, data.index, data.oreNames != null && data.oreNames.size() > 0 ? data.oreNames.get(0) : null, element);
        if (object != null) {
            objectList.add(object);
        }
    }

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "worldGenerator";
    }

    @Override
    public String getLoadOrder() {
        return "block";
    }
}

