/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.crafting.shapeless;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.JsonCraftingRecipeData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class JsonShapelessRecipeData
extends JsonCraftingRecipeData {
    public final Object[] data;
    public final boolean largeGrid;

    public JsonShapelessRecipeData(IJsonProcessor processor, Object output, Object[] data, boolean largeGrid) {
        super(processor, output, data);
        this.data = data;
        this.largeGrid = largeGrid;
    }

    @Override
    protected void convertData() {
        for (int i = 0; i < this.data.length; ++i) {
            Object out;
            Object dataObject = this.data[i];
            if (this.canConvertToItem(dataObject)) {
                out = this.convertItemEntry(dataObject);
                if (out == null) {
                    Engine.logger().error("The item value of [" + dataObject + "] could not be parsed into a valid recipe item entry. Recipe -> " + this);
                    return;
                }
            } else {
                Engine.logger().error("The item value of [" + dataObject + "] is not a valid string for parsing. Recipe -> " + this);
                return;
            }
            this.data[i] = out;
        }
    }

    @Override
    protected IRecipe getRecipe() {
        if (this.output instanceof Block) {
            return new ShapelessOreRecipe((Block)this.output, this.data);
        }
        if (this.output instanceof Item) {
            return new ShapelessOreRecipe((Item)this.output, this.data);
        }
        if (this.output instanceof ItemStack) {
            return new ShapelessOreRecipe((ItemStack)this.output, this.data);
        }
        Engine.logger().error("The type of output value [" + this.output + "] could not be recognized for recipe creation. Recipe -> " + this);
        return null;
    }

    @Override
    public String toString() {
        return "JsonShapelessRecipeData[ out = " + this.output + ", data = " + this.data + "]";
    }

    @Override
    public String getContentID() {
        return null;
    }
}

