/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.meta;

import com.builtbroken.mc.framework.json.imp.IJSONMetaConvert;
import com.builtbroken.mc.framework.json.imp.JsonLoadPhase;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.BlockPropertyData;
import com.builtbroken.mc.seven.framework.block.meta.ItemBlockMeta;
import com.builtbroken.mc.seven.framework.block.meta.MetaData;
import com.builtbroken.mc.seven.framework.block.tile.ITileProvider;
import com.builtbroken.mc.seven.framework.block.tile.TileProviderMeta;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockMeta
extends BlockBase
implements IJSONMetaConvert {
    public static final String META_INDEX_LOCALIZATION_KEY = "${meta}";
    public static final String META_NAME_LOCALIZATION_KEY = "${metaLocalization}";
    public MetaData[] metaDataValues = new MetaData[16];

    public BlockMeta(BlockPropertyData data) {
        super(data);
        ITileProvider provider = data.tileEntityProvider;
        data.tileEntityProvider = new TileProviderMeta();
        ((TileProviderMeta)data.tileEntityProvider).backupProvider = provider;
    }

    @Override
    protected Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockMeta.class;
    }

    @Override
    public void onPhase(JsonLoadPhase phase) {
        if (phase == JsonLoadPhase.LOAD_PHASE_TWO) {
            this.registerOreNames();
        }
    }

    public void registerOreNames() {
        int i;
        if (this.data.oreName != null) {
            if (!this.data.oreName.contains("$")) {
                OreDictionary.registerOre((String)this.data.oreName, (ItemStack)new ItemStack((Block)this));
            } else {
                for (i = 0; i < this.metaDataValues.length; ++i) {
                    if (this.metaDataValues[i] == null) continue;
                    String oreName = this.data.oreName.replace(META_NAME_LOCALIZATION_KEY, this.metaDataValues[i].localization);
                    OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Block)this, 1, i));
                }
            }
        }
        for (i = 0; i < this.metaDataValues.length; ++i) {
            if (this.metaDataValues[i] == null || this.metaDataValues[i].oreNames == null) continue;
            for (String s : this.metaDataValues[i].oreNames) {
                if (s == null || s.isEmpty()) continue;
                OreDictionary.registerOre((String)s, (ItemStack)new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Override
    protected void getRenderStates(Stack<String> stack, int side, int meta) {
        super.getRenderStates(stack, side, meta);
        MetaData data = this.metaDataValues[meta];
        if (data != null) {
            stack.push(data.ID);
            stack.push("tile." + data.ID);
        }
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        super.func_149666_a(item, creativeTabs, list);
        for (MetaData meta : this.metaDataValues) {
            if (meta == null || meta.index == 0) continue;
            list.add(new ItemStack(item, 1, meta.index));
        }
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int func_149692_a(int meta) {
        MetaData data = this.metaDataValues[meta];
        if (data != null) {
            if (data.getItemToDrop() != null) {
                return data.getItemToDrop().func_77960_j();
            }
            if (data.dropIndex >= 0) {
                return data.dropIndex;
            }
        }
        return meta;
    }

    @Override
    public Item func_149650_a(int meta, Random random, int fortune) {
        MetaData data = this.metaDataValues[meta];
        if (data != null && data.getItemToDrop() != null) {
            return data.getItemToDrop().func_77973_b();
        }
        return super.func_149650_a(meta, random, fortune);
    }

    @Override
    public int quantityDropped(int meta, int fortune, Random random) {
        MetaData data = this.metaDataValues[meta];
        if (data != null && data.getItemToDrop() != null) {
            int count = Math.max(1, data.getItemToDrop().field_77994_a);
            if ((data.randomDropBonus > 0 || data.dropFortuneBonus) && Item.func_150898_a((Block)this) != this.func_149650_a(0, random, fortune)) {
                int randomBonus = data.randomDropBonus > 0 ? random.nextInt(data.randomDropBonus) : 0;
                return (count + randomBonus) * (data.dropFortuneBonus ? Math.max(1, fortune) : 1);
            }
            return count;
        }
        return super.quantityDropped(meta, fortune, random);
    }

    @Override
    public int getMetaForValue(String value) {
        for (MetaData data : this.metaDataValues) {
            if (data == null || !data.ID.equalsIgnoreCase(value)) continue;
            return data.index;
        }
        return -1;
    }

    @Override
    protected int getBlockHarvestLevel(int metadata) {
        int level = super.getBlockHarvestLevel(metadata);
        MetaData data = this.metaDataValues[metadata];
        if (data != null && data.harvestLevel > level) {
            level = data.harvestLevel;
        }
        return level;
    }

    @Override
    protected String getBlockHarvestTool(int metadata) {
        MetaData data = this.metaDataValues[metadata];
        if (data != null && data.harvestTool != null) {
            return data.harvestTool;
        }
        return super.getBlockHarvestTool(metadata);
    }

    @Override
    public String toString() {
        return "BlockMeta[" + this.data.name + "]";
    }
}

