/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.data.BlockStateEntry;
import com.builtbroken.mc.seven.framework.block.listeners.AdjacentPlacementListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PathPlacementListener
extends AdjacentPlacementListener {
    @JsonProcessorData(value={"pathRange"}, type="int")
    protected int pathRange = 5;
    protected List<BlockStateEntry> pathBlocks = new ArrayList<BlockStateEntry>();
    protected List<String> pathContentIDs = new ArrayList<String>();

    public PathPlacementListener(Block block) {
        super(block);
    }

    @Override
    protected boolean isPlacementValid() {
        ArrayList<Pos> pathLocations = new ArrayList<Pos>();
        LinkedList<Pos> pathNextList = new LinkedList<Pos>();
        Pos center = new Pos(this);
        if (this.canPath(center)) {
            pathNextList.add(center);
        } else {
            for (ForgeDirection direction : this.supportedDirections == null ? ForgeDirection.VALID_DIRECTIONS : this.supportedDirections) {
                pathNextList.add((Pos)((Object)center.add(direction)));
            }
        }
        while (!pathNextList.isEmpty()) {
            Pos nextPos = (Pos)((Object)pathNextList.poll());
            pathLocations.add(nextPos);
            for (ForgeDirection direction : this.supportedDirections == null ? ForgeDirection.VALID_DIRECTIONS : this.supportedDirections) {
                Pos pos = (Pos)((Object)nextPos.add(direction));
                if (pathLocations.contains((Object)pos) || !this.canPath(pos)) continue;
                if (this.isSupportingTile(this.getBlockAccess(), pos)) {
                    return true;
                }
                pathNextList.add(pos);
            }
        }
        return false;
    }

    protected boolean canPath(Pos pos) {
        return this.isInDistance(pos) && !this.getBlockAccess().func_147437_c(pos.xi(), pos.yi(), pos.zi()) && this.isPathTile(this.getBlockAccess(), pos);
    }

    protected boolean isPathTile(IBlockAccess access, Pos pos) {
        return this.pathBlocks.isEmpty() && this.pathContentIDs.isEmpty() || this.doesContainTile(access, pos, this.pathBlocks, this.pathContentIDs);
    }

    protected boolean isInDistance(Pos pos) {
        if (pos.xi() > this.pathRange + this.xi() || pos.xi() < this.xi() - this.pathRange) {
            return false;
        }
        if (pos.yi() > this.pathRange + this.yi() || pos.yi() < this.yi() - this.pathRange) {
            return false;
        }
        return pos.zi() <= this.pathRange + this.zi() && pos.zi() >= this.zi() - this.pathRange;
    }

    @JsonProcessorData(value={"canPath"})
    public void processPathBlocks(JsonElement inputElement) {
        if (inputElement.isJsonArray()) {
            for (JsonElement element : inputElement.getAsJsonArray()) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("block")) {
                        String blockName = object.getAsJsonPrimitive("block").getAsString();
                        int meta = -1;
                        if (object.has("data")) {
                            meta = object.getAsJsonPrimitive("data").getAsInt();
                        }
                        this.pathBlocks.add(new BlockStateEntry(blockName, meta));
                        continue;
                    }
                    if (object.has("contentID")) {
                        this.pathContentIDs.add(object.getAsJsonPrimitive("contentID").getAsString().toLowerCase());
                        continue;
                    }
                    Engine.logger().warn("AdjacentPlacementListener#process(JsonElement) >> Could not find convert '" + element + "' int a usable type for " + this);
                    continue;
                }
                throw new IllegalArgumentException("Invalid data, block entries must look like \n {\n\t \"block\" : \"minecraft:tnt\",\n\t \"data\" : 0 \n}");
            }
        } else {
            throw new IllegalArgumentException("Invalid data, blocks data must be an array");
        }
    }

    @Override
    public String toString() {
        if (this.contentUseID != null) {
            return "PathFinderPlacementListener[" + this.block + " >> " + this.contentUseID + "]@" + this.hashCode();
        }
        if (this.metaCheck != -1) {
            return "PathFinderPlacementListener[" + this.block + "@" + this.metaCheck + "]@" + this.hashCode();
        }
        return "PathFinderPlacementListener[" + this.block + "]@" + this.hashCode();
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            return new PathPlacementListener(block);
        }

        @Override
        public String getListenerKey() {
            return "pathFinderPlacementListener";
        }
    }
}

