/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileWithListeners;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import java.util.Iterator;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ListenerIterator
implements Iterator<ITileEventListener>,
Iterable<ITileEventListener> {
    private World world;
    private IBlockAccess access;
    private int x;
    private int y;
    private int z;
    private int index = -1;
    private int nextIndex = -1;
    private int size = -1;
    private BlockBase blockBase;
    private TileEntity tile;
    private String key;

    public ListenerIterator(World world, int x, int y, int z, BlockBase blockBase, String key) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockBase = blockBase;
        this.key = key;
    }

    public ListenerIterator(IBlockAccess world, int x, int y, int z, BlockBase blockBase, String key) {
        this.access = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockBase = blockBase;
        this.key = key;
    }

    @Override
    public Iterator<ITileEventListener> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.size == -1) {
            List<ITileEventListener> listenerList;
            this.size = 2;
            if (this.blockBase.listeners.containsKey(this.key)) {
                this.size += this.blockBase.listeners.get(this.key).size();
            }
            if (this.getTileEntity() instanceof ITileWithListeners && (listenerList = ((ITileWithListeners)this.tile).getListeners(this.key)) != null) {
                this.size += listenerList.size();
            }
        }
        while (this.peek() == null && this.nextIndex < this.size) {
            ++this.nextIndex;
        }
        return this.peek() != null;
    }

    @Override
    public ITileEventListener next() {
        if (this.get(this.index) instanceof IBlockListener) {
            ((IBlockListener)((Object)this.get(this.index))).eject();
        }
        ITileEventListener re = this.peek();
        this.index = this.nextIndex++;
        return re;
    }

    protected ITileEventListener peek() {
        return this.get(this.nextIndex);
    }

    protected ITileEventListener get(int index) {
        if (index >= 0) {
            ITileEventListener re = null;
            if (index == 0) {
                TileEntity tile = this.getTileEntity();
                if (tile instanceof ITileEventListener) {
                    re = (ITileEventListener)tile;
                }
            } else if (index == 1) {
                TileEntity tile = this.getTileEntity();
                if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof ITileEventListener) {
                    re = (ITileEventListener)((Object)((ITileNodeHost)tile).getTileNode());
                }
            } else {
                int i = index - 2;
                if (this.blockBase.listeners.get(this.key) != null && i < this.blockBase.listeners.get(this.key).size()) {
                    re = this.blockBase.listeners.get(this.key).get(i);
                } else {
                    List<ITileEventListener> listenerList;
                    TileEntity tile = this.getTileEntity();
                    if (tile instanceof ITileWithListeners && (listenerList = ((ITileWithListeners)tile).getListeners(this.key)) != null && i < listenerList.size()) {
                        re = listenerList.get(i);
                    }
                }
            }
            if (re instanceof IBlockListener) {
                if (this.world != null) {
                    ((IBlockListener)((Object)re)).inject((IBlockAccess)this.world, this.xi(), this.yi(), this.zi());
                } else {
                    ((IBlockListener)((Object)re)).inject(this.access, this.xi(), this.yi(), this.zi());
                }
            }
            return re != null && re.isValidForTile() ? re : null;
        }
        return null;
    }

    public TileEntity getTileEntity() {
        if (this.tile == null) {
            if (this.world() != null) {
                this.tile = this.world().func_147438_o(this.xi(), this.yi(), this.zi());
            } else if (this.access != null) {
                this.tile = this.access.func_147438_o(this.xi(), this.yi(), this.zi());
            }
        }
        return this.tile;
    }

    public World world() {
        if (this.access instanceof World) {
            return this.world;
        }
        return this.world;
    }

    public int xi() {
        return this.x;
    }

    public int yi() {
        return this.y;
    }

    public int zi() {
        return this.z;
    }
}

