/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.client.listeners.blocks;

import com.builtbroken.mc.api.tile.client.IJsonIconState;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import com.builtbroken.mc.seven.framework.block.listeners.client.IIconListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class JsonIconListener
extends TileListener
implements IIconListener,
IBlockListener {
    public final BlockBase block;

    public JsonIconListener(BlockBase block) {
        this.block = block;
    }

    @Override
    public IIcon getTileIcon(int side, int meta) {
        TileEntity tileEntity;
        RenderData renderData = this.block.getRenderData(meta);
        if (renderData != null && (tileEntity = this.getTileEntity()) != null) {
            String id;
            IJsonIconState node = null;
            if (tileEntity instanceof IJsonIconState) {
                node = (IJsonIconState)tileEntity;
            } else if (tileEntity instanceof ITileNodeHost && ((ITileNodeHost)tileEntity).getTileNode() instanceof IJsonIconState) {
                node = (IJsonIconState)((Object)((ITileNodeHost)tileEntity).getTileNode());
            }
            if (node != null && (id = node.getContentStateForSide(side, meta)) != null && !id.isEmpty()) {
                for (String key : new String[]{"block." + id, "tile." + id}) {
                    IRenderState state = renderData.getState(key);
                    if (state == null || state.getIcon(side) == null) continue;
                    return state.getIcon(side);
                }
            }
        }
        return this.block.getIconFromJson(side, meta);
    }

    @Override
    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("icon");
        return list;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            if (block instanceof BlockBase) {
                return new JsonIconListener((BlockBase)block);
            }
            return null;
        }

        @Override
        public String getListenerKey() {
            return "jsonTileIcon";
        }
    }
}

