/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.abstraction.world;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.abstraction.EffectInstance;
import com.builtbroken.mc.api.abstraction.data.ITileData;
import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.api.abstraction.tile.ITile;
import com.builtbroken.mc.api.abstraction.tile.ITilePosition;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticle;
import com.builtbroken.mc.core.network.packet.callback.PacketAudio;
import com.builtbroken.mc.seven.abstraction.entity.EntityData;
import com.builtbroken.mc.seven.abstraction.tile.TileInstance;
import com.builtbroken.mc.seven.abstraction.world.TilePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class WorldWrapper
implements IWorld {
    private int dim;

    public WorldWrapper(World world) {
        this.dim = world.field_73011_w.field_76574_g;
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    public boolean isValid() {
        return this.getWorld() != null;
    }

    @Override
    public ITile getTile(int x, int y, int z) {
        return this.getTile(this.getTilePosition(x, y, z));
    }

    @Override
    public ITile getTile(ITilePosition position) {
        if (position instanceof TilePosition) {
            return new TileInstance((TilePosition)position);
        }
        return this.getTile(position.xCoord(), position.yCoord(), position.zCoord());
    }

    @Override
    public boolean setTile(String key, int x, int y, int z) {
        return this.setTile(Engine.minecraft.getTileData(key), x, y, z);
    }

    @Override
    public boolean setTile(ITileData data, int x, int y, int z) {
        if (data != null) {
            return this.getWorld().func_147449_b(x, y, z, (Block)data.unwrap());
        }
        return false;
    }

    @Override
    public boolean isLocationLoaded(int x, int y, int z) {
        if (this.getWorld() instanceof WorldServer) {
            return ((WorldServer)this.getWorld()).field_73059_b.func_73149_a(x >> 4, z >> 4) && this.getWorld().func_72938_d((int)x, (int)z).field_76636_d;
        }
        return this.getWorld().func_72863_F().func_73149_a(x >> 4, z >> 4) && this.getWorld().func_72938_d((int)x, (int)z).field_76636_d;
    }

    @Override
    public List<IEntityData> getEntitiesInRange(double x, double y, double z, double range) {
        return new ArrayList<IEntityData>();
    }

    @Override
    public ITilePosition getTilePosition(int x, int y, int z) {
        return new TilePosition(this, x, y, z);
    }

    @Override
    public IEntityData getEntityData(int id) {
        Entity entity = this.getWorld().func_73045_a(id);
        if (entity != null) {
            return new EntityData(entity);
        }
        return null;
    }

    @Override
    public EffectInstance newEffect(String key, IPos3D pos) {
        return new EffectInstance(this, key, pos);
    }

    @Override
    public void runEffect(EffectInstance effectInstance) {
        if (this.isServer()) {
            PacketSpawnParticle packet = new PacketSpawnParticle("JSON_" + effectInstance.key, this.dim, effectInstance.x, effectInstance.y, effectInstance.z, effectInstance.mx, effectInstance.my, effectInstance.mz);
            if (effectInstance.data != null && !effectInstance.data.isEmpty()) {
                packet.otherData = new NBTTagCompound();
                for (Map.Entry<String, Object> entry : effectInstance.data.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof Integer) {
                        packet.otherData.func_74768_a(entry.getKey(), ((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        packet.otherData.func_74776_a(entry.getKey(), ((Float)value).floatValue());
                        continue;
                    }
                    if (value instanceof String) {
                        packet.otherData.func_74778_a(entry.getKey(), (String)value);
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    packet.otherData.func_74780_a(entry.getKey(), ((Double)value).doubleValue());
                }
            }
            packet.endPoint = effectInstance.endPoint;
            Engine.packetHandler.sendToAllAround(packet, this.getWorld(), effectInstance.x, effectInstance.y, effectInstance.z, 100.0);
        }
    }

    @Override
    public void spawnParticle(String name, double x, double y, double z, double xx, double yy, double zz) {
        if (this.isServer()) {
            PacketSpawnParticle packet = new PacketSpawnParticle(name, this.getWorld(), x, y, z, xx, yy, zz);
            Engine.packetHandler.sendToAllAround(packet, this.getWorld(), x, y, z, 100.0);
        }
    }

    @Override
    public void playAudio(String audioKey, double x, double y, double z, float pitch, float volume) {
        if (this.isServer()) {
            PacketAudio packetAudio = new PacketAudio(this.getWorld(), audioKey, x, y, z, pitch, volume);
            Engine.packetHandler.sendToAllAround(packetAudio, this.getWorld(), x, y, z, 100.0);
        }
    }

    @Override
    public boolean isClient() {
        return this.getWorld().field_72995_K;
    }

    @Override
    public boolean isServer() {
        return !this.getWorld().field_72995_K;
    }

    @Override
    public int getDimID() {
        return this.dim;
    }

    @Override
    public World unwrap() {
        return this.getWorld();
    }
}

