/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.mods.ic;

import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.api.event.tile.TileEvent;
import com.builtbroken.mc.api.tile.ConnectionType;
import com.builtbroken.mc.api.tile.ITileConnection;
import com.builtbroken.mc.mods.ic.ICHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ICStaticForwarder {
    public static final ICStaticForwarder INSTANCE = new ICStaticForwarder();

    public static double getDemandedEnergy(IEnergyBufferProvider buffer) {
        return buffer.getEnergyBuffer(null) != null ? (double)(buffer.getEnergyBuffer(null).getMaxBufferSize() - buffer.getEnergyBuffer(null).getEnergyStored()) : 0.0;
    }

    public static int getSinkTier(IEnergyBufferProvider buffer) {
        return Integer.MAX_VALUE;
    }

    public static double injectEnergy(IEnergyBufferProvider buffer, ForgeDirection directionFrom, double amount, double voltage) {
        if (buffer.getEnergyBuffer(directionFrom) != null) {
            return (double)buffer.getEnergyBuffer(directionFrom).addEnergyToStorage((int)(amount * ICHandler.TO_UE), true) * ICHandler.FROM_UE;
        }
        return 0.0;
    }

    public static boolean acceptsEnergyFrom(IEnergyBufferProvider buffer, TileEntity emitter, ForgeDirection direction) {
        return !(buffer instanceof ITileConnection) || ((ITileConnection)((Object)buffer)).canConnect(emitter, ConnectionType.IC_POWER, direction);
    }

    private ICStaticForwarder() {
    }

    @SubscribeEvent
    public void load(TileEvent.TileLoadEvent event) {
        TileEntity sink = event.tile();
        if (sink instanceof IEnergySink && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)((IEnergySink)sink)));
        }
    }

    @SubscribeEvent
    public void unload(TileEvent.TileUnLoadEvent event) {
        TileEntity sink = event.tile();
        if (sink instanceof IEnergySink) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)((IEnergySink)sink)));
        }
    }
}

