/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.modflag;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.sorting.Vector3DistanceComparator;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Selection
extends Cube {
    protected World world;

    public Selection() {
        this(null, new Cube());
    }

    public Selection(World world, Cube cube) {
        super(cube);
        this.world = world;
    }

    public Selection(World world, IPos3D min, IPos3D max) {
        super(min, max);
        this.world = world;
    }

    public Selection(NBTTagCompound nbt) {
        super(nbt);
    }

    public Selection(ByteBuf buf) {
        super(buf);
    }

    public List<Pos> replaceBlocks(Block block, int meta) {
        List<Pos> list = this.getBlockLocations(block, meta);
        for (Pos Pos2 : list) {
            Pos2.setBlock(this.world, block, meta);
        }
        return list;
    }

    public List<Pos> getBlockLocations() {
        return this.getBlockLocations(null, -1, -1);
    }

    public List<Pos> getBlockLocations(Block block) {
        return this.getBlockLocations(block, -1, -1);
    }

    public List<Pos> getBlockLocations(Block block, int meta) {
        return this.getBlockLocations(block, meta, -1);
    }

    public List<Pos> getBlockLocations(Block block, int meta, int size) {
        LinkedList<Pos> list = new LinkedList<Pos>();
        for (int y = this.min().yi(); y <= this.max().yi(); ++y) {
            for (int x = this.min().xi(); x <= this.max().xi(); ++x) {
                for (int z = this.min().zi(); z <= this.max().zi(); ++z) {
                    if (size > 0 && list.size() > size) {
                        return list;
                    }
                    Pos Pos2 = new Pos(x, y, z);
                    Block b = Pos2.getBlock((IBlockAccess)this.world);
                    int m = Pos2.getBlockMetadata((IBlockAccess)this.world);
                    if (block != null && (b != block || meta != -1 && m != meta)) continue;
                    list.add(Pos2);
                }
            }
        }
        return list;
    }

    public List<Pos> getLocationsWithin(Location location, int size, int distance) {
        LinkedList<Pos> list = new LinkedList<Pos>();
        if (distance > 0) {
            int min_y = (int)Math.max((double)this.min().yi(), location.y() - (double)distance);
            int max_y = (int)Math.min((double)this.max().yi(), location.y() + (double)distance);
            int min_x = (int)Math.max((double)this.min().xi(), location.x() - (double)distance);
            int max_x = (int)Math.min((double)this.max().xi(), location.x() + (double)distance);
            int min_z = (int)Math.max((double)this.min().zi(), location.z() - (double)distance);
            int max_z = (int)Math.min((double)this.max().zi(), location.z() + (double)distance);
            for (int y = min_y; y <= max_y; ++y) {
                for (int x = min_x; x <= max_x; ++x) {
                    for (int z = min_z; z <= max_z; ++z) {
                        Block b;
                        if (size > 0 && list.size() >= size) {
                            Collections.sort(list, new Vector3DistanceComparator(location));
                            return list;
                        }
                        Pos pos = new Pos(x, y, z);
                        if (!(location.distance(pos) <= (double)distance) || (b = pos.getBlock((IBlockAccess)location.oldWorld())) == null || pos.isAirBlock(location.oldWorld()) || !(pos.getHardness(location.oldWorld()) >= 0.0f)) continue;
                        list.add(pos);
                    }
                }
            }
        }
        return list;
    }
}

