/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.modflag;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.framework.access.AccessUser;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.modflag.Region;
import com.builtbroken.mc.modflag.RegionManager;
import com.builtbroken.mc.modflag.events.PlayerRegionEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class RegionController
implements IVirtualObject {
    public final int dim;
    protected HashMap<String, Region> regions = new HashMap();

    public RegionController(int dim) {
        this.dim = dim;
        this.load(NBTUtility.loadData(this.getSaveFile()));
        SaveManager.register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Region getRegion(String name) {
        if (this.regions.containsKey(name)) {
            return this.regions.get(name);
        }
        return null;
    }

    public List<Region> getRegionsAtLocation(IPos3D pos) {
        ArrayList<Region> list = new ArrayList<Region>();
        for (Region region : this.regions.values()) {
            if (!region.doesContainPoint(pos)) continue;
            list.add(region);
        }
        return list;
    }

    public List<Region> getRegionsNear(EntityPlayerMP player, int distance) {
        ArrayList<Region> regions = new ArrayList<Region>();
        Location location = new Location((Entity)player);
        for (Region region : this.regions.values()) {
            if (!region.isCloseToAnyCorner(location, distance)) continue;
            regions.add(region);
        }
        return regions;
    }

    public boolean removeRegion(Region region) {
        return this.regions.containsKey(region.name) && this.regions.remove(region.name) != null;
    }

    public Region createNewRegion(String name, Cube cube) {
        if (this.getRegion(name) == null && cube.isValid()) {
            Region region = new Region(name);
            region.segments.add(cube);
            this.regions.put(name, region);
            return region;
        }
        return null;
    }

    @Override
    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), "ve/modflags/region_dim_" + this.dim + ".dat");
    }

    @Override
    public void setSaveFile(File file) {
    }

    @Override
    public boolean shouldSaveForWorld(World world) {
        return world != null && world.field_73011_w.field_76574_g == this.dim;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("regions")) {
            this.regions.clear();
            NBTTagList list = nbt.func_150295_c("regions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String name = list.func_150305_b(i).func_74779_i("region_name");
                Region region = new Region(name);
                region.load(list.func_150305_b(i));
                this.regions.put(name, region);
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (!this.regions.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, Region> entry : this.regions.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("region_name", entry.getKey());
                list.func_74742_a((NBTBase)entry.getValue().save(tag));
            }
            nbt.func_74782_a("regions", (NBTBase)list);
        }
        return nbt;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == this.dim) {
            EntityPlayer player = event.entityPlayer;
            List<Region> regionList = this.getRegionsAtLocation(new Pos(event.x, event.y, event.z));
            if (regionList != null && regionList.size() > 0) {
                for (Region region : regionList) {
                    AccessUser user = region.getAccessProfile().getUserAccess(player);
                    if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                        if (user.hasNode(RegionManager.leftClick.toString())) continue;
                        event.setCanceled(true);
                        player.func_146105_b((IChatComponent)new ChatComponentText("You do not have the permission to do that here!"));
                        continue;
                    }
                    if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || user.hasNode(RegionManager.rightClick.toString())) continue;
                    event.setCanceled(true);
                    player.func_146105_b((IChatComponent)new ChatComponentText("You do not have the permission to do that here!"));
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K && event.world.field_73011_w.field_76574_g == this.dim) {
            long ticks = event.world.func_72912_H().func_76073_f();
            ArrayList<PlayerRegionEvent> events = new ArrayList<PlayerRegionEvent>();
            if (ticks % 3L == 0L) {
                for (Object e : event.world.field_73010_i) {
                    if (!(e instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)e;
                    Location location = new Location((Entity)player);
                    for (Region region : this.regions.values()) {
                        if (region.doesContainPoint(location) && !region.players_in_region.contains(player)) {
                            events.add(new PlayerRegionEvent.PlayerEnterRegionEvent(player, region));
                            continue;
                        }
                        if (region.doesContainPoint(location) || !region.players_in_region.contains(player)) continue;
                        events.add(new PlayerRegionEvent.PlayerExitRegionEvent(player, region));
                    }
                }
            }
            for (Event event2 : events) {
                MinecraftForge.EVENT_BUS.post(event2);
            }
        }
    }

    static {
        SaveManager.registerClass("regionController", RegionController.class);
    }
}

