/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.radio.network;

import com.builtbroken.mc.api.map.radio.IRadioWaveReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.api.map.radio.wireless.ConnectionRemovedReason;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessConnector;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessDataPoint;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetwork;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkHub;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkObject;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.lib.world.map.radio.RadioMap;
import com.builtbroken.mc.lib.world.map.radio.RadioRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class WirelessNetwork
implements IWirelessNetwork {
    protected IWirelessNetworkHub hub;
    protected final List<IWirelessConnector> wirelessConnectors = new ArrayList<IWirelessConnector>();
    protected final HashMap<IWirelessConnector, List<IWirelessNetworkObject>> connectorToConnections = new HashMap();
    protected final List<IWirelessNetworkObject> attachedDevices = new ArrayList<IWirelessNetworkObject>();
    protected final List<IWirelessDataPoint> dataPoints = new ArrayList<IWirelessDataPoint>();

    public WirelessNetwork(IWirelessNetworkHub hub) {
        this.hub = hub;
    }

    @Override
    public IWirelessNetworkHub getPrimarySender() {
        return this.hub;
    }

    @Override
    public List<IWirelessConnector> getWirelessConnectors() {
        return this.wirelessConnectors;
    }

    @Override
    public List<IRadioWaveSender> getRelayStations() {
        return new ArrayList<IRadioWaveSender>();
    }

    @Override
    public List<IWirelessNetworkObject> getAttachedObjects() {
        return this.attachedDevices;
    }

    @Override
    public float getHz() {
        return this.hub.getBroadCastFrequency();
    }

    @Override
    public boolean addConnection(IWirelessConnector connector, IWirelessNetworkObject object) {
        if (!this.attachedDevices.contains(object)) {
            this.addConnection(object);
            List<IWirelessNetworkObject> objects = this.connectorToConnections.get(connector);
            if (objects == null) {
                objects = new ArrayList<IWirelessNetworkObject>();
            }
            objects.add(object);
            this.connectorToConnections.put(connector, objects);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnection(IWirelessConnector connector, IWirelessNetworkObject object) {
        if (this.attachedDevices.contains(object)) {
            this.attachedDevices.remove(object);
            List<IWirelessNetworkObject> objects = this.connectorToConnections.get(connector);
            if (objects == null) {
                objects = new ArrayList<IWirelessNetworkObject>();
            }
            objects.remove(object);
            this.connectorToConnections.put(connector, objects);
            if (object instanceof IWirelessDataPoint) {
                this.dataPoints.remove(object);
            }
            object.removeWirelessNetwork(this, ConnectionRemovedReason.CONNECTION_LOST);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnector(IWirelessConnector connector) {
        if (this.wirelessConnectors.contains(connector)) {
            this.clearConnections(connector);
            return this.wirelessConnectors.remove(connector);
        }
        return false;
    }

    protected void clearConnections(IWirelessConnector connector) {
        List<IWirelessNetworkObject> objects = this.connectorToConnections.get(connector);
        if (objects != null) {
            for (IWirelessNetworkObject object : objects) {
                this.attachedDevices.remove(object);
                if (!(object instanceof IWirelessDataPoint)) continue;
                this.dataPoints.remove(object);
            }
        }
        this.connectorToConnections.remove(connector);
        for (IWirelessNetworkObject obj : connector.getWirelessNetworkObjects()) {
            this.attachedDevices.remove(obj);
            if (!(obj instanceof IWirelessDataPoint)) continue;
            this.dataPoints.remove(obj);
        }
    }

    public void updateConnections() {
        if (this.hub != null && this.hub.getWirelessCoverageArea() != null) {
            Cube range = this.hub.getWirelessCoverageArea();
            RadioMap map = RadioRegistry.getRadioMapForWorld(this.hub.oldWorld());
            List<IRadioWaveReceiver> receivers = map.getReceiversInRange(range, this.hub instanceof IRadioWaveReceiver ? (IRadioWaveReceiver)((Object)this.hub) : null);
            if (!receivers.isEmpty()) {
                for (IRadioWaveReceiver receiver : receivers) {
                    if (!(receiver instanceof IWirelessConnector) || this.addConnector((IWirelessConnector)((Object)receiver)) || !this.wirelessConnectors.contains(receiver)) continue;
                    for (IWirelessNetworkObject object : ((IWirelessConnector)((Object)receiver)).getWirelessNetworkObjects()) {
                        this.addConnection((IWirelessConnector)((Object)receiver), object);
                    }
                }
            }
            if (this.getPrimarySender() instanceof IWirelessConnector) {
                this.addConnector((IWirelessConnector)((Object)this.getPrimarySender()));
            }
            Iterator<IWirelessConnector> it2 = this.wirelessConnectors.iterator();
            while (it2.hasNext()) {
                IWirelessConnector con = it2.next();
                if ((!(con instanceof TileEntity) || !((TileEntity)con).func_145837_r()) && (!(con instanceof Entity) || ((Entity)con).func_70089_S())) continue;
                it2.remove();
                this.clearConnections(con);
                con.removeWirelessNetwork(this, ConnectionRemovedReason.TILE_INVALIDATE);
            }
            Iterator<IWirelessNetworkObject> it = this.attachedDevices.iterator();
            while (it.hasNext()) {
                IWirelessNetworkObject obj = it.next();
                if ((!(obj instanceof TileEntity) || !((TileEntity)obj).func_145837_r()) && (!(obj instanceof Entity) || ((Entity)obj).func_70089_S())) continue;
                it.remove();
                obj.removeWirelessNetwork(this, ConnectionRemovedReason.TILE_INVALIDATE);
                if (!(obj instanceof IWirelessDataPoint)) continue;
                this.dataPoints.remove(obj);
            }
        } else {
            this.kill();
        }
    }

    @Override
    public boolean addConnector(IWirelessConnector receiver) {
        if (receiver.canConnectToNetwork(this)) {
            boolean added = false;
            if (!this.wirelessConnectors.contains(receiver) && (added = this.wirelessConnectors.add(receiver))) {
                receiver.addWirelessNetwork(this);
                if (!this.attachedDevices.contains(receiver)) {
                    this.attachedDevices.add(receiver);
                    if (receiver instanceof IWirelessDataPoint) {
                        this.dataPoints.add((IWirelessDataPoint)((Object)receiver));
                    }
                }
            }
            List<IWirelessNetworkObject> objects = receiver.getWirelessNetworkObjects();
            for (IWirelessNetworkObject object : objects) {
                this.addConnection(object);
            }
            return added;
        }
        return false;
    }

    protected void addConnection(IWirelessNetworkObject object) {
        if (!this.attachedDevices.contains(object)) {
            this.attachedDevices.add(object);
            object.addWirelessNetwork(this);
            if (object instanceof IWirelessDataPoint) {
                this.dataPoints.add((IWirelessDataPoint)object);
            }
        }
    }

    public void kill() {
        Iterator<IWirelessConnector> it2 = this.wirelessConnectors.iterator();
        while (it2.hasNext()) {
            IWirelessConnector con = it2.next();
            con.removeWirelessNetwork(this, ConnectionRemovedReason.TILE_INVALIDATE);
            it2.remove();
        }
        Iterator<IWirelessNetworkObject> it = this.attachedDevices.iterator();
        while (it.hasNext()) {
            IWirelessNetworkObject obj = it.next();
            it.remove();
            obj.removeWirelessNetwork(this, ConnectionRemovedReason.TILE_INVALIDATE);
            if (!(obj instanceof IWirelessDataPoint)) continue;
            this.dataPoints.remove(obj);
        }
    }

    public String toString() {
        return "WirelessNetwork[" + this.hub.getBroadCastFrequency() + ", " + this.wirelessConnectors.size() + " connectors, " + this.dataPoints.size() + "/" + this.attachedDevices.size() + " dataPoints, " + this.hub;
    }
}

