/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.render.model;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.model.Face;
import com.builtbroken.jlib.model.Mesh;
import com.builtbroken.jlib.model.UVPoint;
import com.builtbroken.jlib.model.Vert;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class Model
implements Cloneable {
    public final List<Mesh> meshes = new ArrayList<Mesh>();
    public boolean render_wireframe = false;
    public boolean render_normals = false;

    public Model(Mesh ... meshes) {
        if (meshes != null) {
            for (Mesh mesh : meshes) {
                this.meshes.add(mesh);
            }
        }
    }

    public void render() {
        if (this.render_wireframe) {
            GL11.glBegin((int)2);
        } else {
            GL11.glBegin((int)4);
        }
        for (Mesh m : this.meshes) {
            for (Face face : m.getFaces()) {
                try {
                    this.renderVert(m, face, 0);
                    this.renderVert(m, face, 1);
                    this.renderVert(m, face, 2);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        GL11.glEnd();
        if (this.render_normals) {
            GL11.glColor3f((float)Color.BLUE.getRed(), (float)Color.BLUE.getGreen(), (float)Color.BLUE.getBlue());
            for (Mesh m : this.meshes) {
                for (Face face : m.getFaces()) {
                    Vert center = Model.center2((Vert)m.vertices.get(face.vertexIndices[0]), (Vert)m.vertices.get(face.vertexIndices[1]), (Vert)m.vertices.get(face.vertexIndices[2]));
                    Vert out = (Vert)center.add((IPos3D)m.normals.get(face.normalIndices[0]));
                    GL11.glBegin((int)2);
                    GL11.glVertex3f((float)center.xf(), (float)center.yf(), (float)center.zf());
                    GL11.glVertex3f((float)out.xf(), (float)out.yf(), (float)out.zf());
                    GL11.glEnd();
                }
            }
        }
    }

    public void tessellate() {
        Tessellator.field_78398_a.func_78371_b(4);
        for (Mesh m : this.meshes) {
            for (Face face : m.getFaces()) {
                this.tessVert(m, face, 0);
                this.tessVert(m, face, 1);
                this.tessVert(m, face, 2);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    protected void tessVert(Mesh m, Face face, int i) {
        Vert n1 = (Vert)m.vertices.get(face.vertexIndices[i]);
        UVPoint t1 = (UVPoint)m.textureCoordinates.get(face.textureCoordinateIndices[i]);
        Tessellator.field_78398_a.func_78374_a((double)n1.xf(), (double)n1.yf(), (double)n1.zf(), (double)t1.xf(), (double)t1.yf());
    }

    protected void renderVert(Mesh m, Face face, int i) {
        Vert n1 = (Vert)m.normals.get(face.normalIndices[i]);
        GL11.glNormal3f((float)n1.xf(), (float)n1.yf(), (float)n1.zf());
        Vert v1 = (Vert)m.getVertices().get(face.vertexIndices[i]);
        GL11.glVertex3f((float)v1.xf(), (float)v1.yf(), (float)v1.zf());
        if (m.textureCoordinates.size() >= face.textureCoordinateIndices[i]) {
            UVPoint t1 = (UVPoint)m.textureCoordinates.get(face.textureCoordinateIndices[i]);
            GL11.glTexCoord2f((float)t1.xf(), (float)t1.yf());
        }
    }

    static Vert center2(Vert v1, Vert v2, Vert v3) {
        return (Vert)((Vert)((Vert)v1.add((IPos3D)v2)).add((IPos3D)v3)).divide(3.0);
    }

    public Model clone() {
        Model model = new Model(new Mesh[0]);
        for (Mesh mesh : this.meshes) {
            model.meshes.add(mesh.clone());
        }
        model.render_normals = this.render_normals;
        model.render_wireframe = this.render_wireframe;
        return model;
    }
}

