/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.data.mass;

import com.builtbroken.mc.api.IHasMass;
import com.builtbroken.mc.api.IMassRegistry;
import com.builtbroken.mc.api.items.IItemHasMass;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class MassRegistry
implements IMassRegistry {
    private HashMap<Class<? extends Entity>, Double> entityMass = new HashMap();
    private HashMap<Item, Double> itemMass = new HashMap();
    private HashMap<Block, Double> blockMass = new HashMap();
    private HashMap<ItemStackWrapper, Double> stackMass = new HashMap();

    @Override
    public void setMass(Class<? extends Entity> entity, double mass) {
        if (entity != null) {
            if (mass < 0.0) {
                Engine.logger().error("Mass is negative, setting to positive", (Throwable)new RuntimeException());
            }
            this.entityMass.put(entity, Math.abs(mass));
        } else {
            Engine.logger().error("Class can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void setMass(Item item, double mass) {
        if (item != null) {
            if (mass < 0.0) {
                Engine.logger().error("Mass is negative, setting to positive", (Throwable)new RuntimeException());
            }
            this.itemMass.put(item, Math.abs(mass));
        } else {
            Engine.logger().error("Item can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void setMass(Item item, int meta, double mass) {
        if (item != null) {
            this.setMass(new ItemStack(item, 1, meta), mass);
        } else {
            Engine.logger().error("Item can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void setMass(Block block, double mass) {
        if (block != null) {
            this.blockMass.put(block, Math.abs(mass));
        } else {
            Engine.logger().error("Item can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void setMass(Block block, int meta, double mass) {
        if (block != null) {
            this.setMass(new ItemStack(block, 1, meta), mass);
        } else {
            Engine.logger().error("Item can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void setMass(ItemStack stack, double mass) {
        if (stack != null) {
            ItemStackWrapper wrapper = new ItemStackWrapper(stack);
            if (mass < 0.0) {
                Engine.logger().error("Mass is negative, setting to positive", (Throwable)new RuntimeException());
            }
            this.stackMass.put(wrapper, Math.abs(mass));
        } else {
            Engine.logger().error("Item can not be null", (Throwable)new RuntimeException());
        }
    }

    @Override
    public double getMass(World world, int x, int y, int z) {
        if (world != null) {
            double mass;
            ChunkProviderServer providerServer;
            if (world instanceof WorldServer && !(providerServer = ((WorldServer)world).field_73059_b).func_73149_a(x >> 4, z >> 4)) {
                return -1.0;
            }
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IHasMass && (mass = ((IHasMass)tile).getMass()) >= 0.0) {
                return mass;
            }
            mass = this.getMass(block, meta);
            return mass >= 0.0 ? mass : this.getMass(block);
        }
        return -1.0;
    }

    @Override
    public double getMass(Entity entity) {
        double mass;
        if (entity instanceof IHasMass && (mass = ((IHasMass)entity).getMass()) >= 0.0) {
            return mass;
        }
        Class<? extends Entity> clazz = entity.getClass();
        if (this.entityMass.containsKey(clazz)) {
            return this.entityMass.get(clazz);
        }
        for (Class<? extends Entity> cl : this.entityMass.keySet()) {
            if (!clazz.isAssignableFrom(cl)) continue;
            return this.entityMass.get(cl);
        }
        return -1.0;
    }

    @Override
    public double getMass(ItemStack stack) {
        if (stack != null) {
            double mass;
            Item item = stack.func_77973_b();
            if (item instanceof IItemHasMass && (mass = ((IItemHasMass)item).getMass(stack)) >= 0.0) {
                return mass;
            }
            ItemStackWrapper wrapper = new ItemStackWrapper(stack);
            mass = this.stackMass.get(wrapper);
            return mass >= 0.0 ? mass : this.getMass(item);
        }
        return -1.0;
    }

    @Override
    public double getMass(Block block) {
        if (block != null) {
            return this.blockMass.get(block);
        }
        return -1.0;
    }

    @Override
    public double getMass(Block block, int meta) {
        if (block != null) {
            return this.getMass(new ItemStack(block, 1, meta));
        }
        return -1.0;
    }

    @Override
    public double getMass(Item item) {
        if (item != null) {
            return this.blockMass.get(item);
        }
        return -1.0;
    }

    @Override
    public double getMass(Item item, int meta) {
        if (item != null) {
            return this.getMass(new ItemStack(item, 1, meta));
        }
        return -1.0;
    }
}

