/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.data.item;

import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackWrapper {
    public final ItemStack itemStack;
    public boolean meta_compare = true;
    public boolean nbt_compare = true;
    public boolean stack_size = false;

    public ItemStackWrapper(ItemStack itemStack) {
        if (itemStack != null) {
            this.itemStack = itemStack.func_77946_l();
            if (!itemStack.func_77981_g()) {
                this.meta_compare = false;
            }
            if (itemStack.func_77978_p() == null) {
                this.nbt_compare = false;
            }
        } else {
            this.itemStack = null;
            this.meta_compare = false;
            this.nbt_compare = false;
        }
    }

    public ItemStackWrapper(Item item) {
        this.itemStack = new ItemStack(item);
        this.meta_compare = false;
        this.nbt_compare = false;
    }

    public ItemStackWrapper(Block block) {
        this.itemStack = new ItemStack(block);
        this.meta_compare = false;
        this.nbt_compare = false;
    }

    public ItemStackWrapper setMetaCompare(boolean b) {
        this.meta_compare = b;
        return this;
    }

    public ItemStackWrapper setNBTCompare(boolean b) {
        this.nbt_compare = b;
        return this;
    }

    public ItemStackWrapper setStackCompare(boolean b) {
        this.stack_size = b;
        return this;
    }

    public boolean equals(Object object) {
        boolean size;
        boolean item = false;
        boolean meta = !this.meta_compare;
        boolean nbt = !this.nbt_compare;
        boolean bl = size = !this.stack_size;
        if (this.itemStack == null || object == null) {
            return false;
        }
        if (object instanceof ItemStack || object instanceof ItemStackWrapper) {
            ItemStack i = object instanceof ItemStack ? (ItemStack)object : ((ItemStackWrapper)object).itemStack;
            boolean bl2 = item = this.itemStack.func_77973_b() == i.func_77973_b();
            if (this.meta_compare) {
                boolean bl3 = meta = this.itemStack.func_77960_j() == i.func_77960_j();
            }
            if (this.stack_size) {
                boolean bl4 = size = this.itemStack.field_77994_a == i.field_77994_a;
            }
            if (this.nbt_compare) {
                nbt = InventoryUtility.doesStackNBTMatch(this.itemStack, i);
            }
        } else if (!(this.meta_compare || this.nbt_compare || this.stack_size)) {
            if (object instanceof Item) {
                item = this.itemStack.func_77973_b() == object;
            } else if (object instanceof Block) {
                item = this.itemStack.func_77973_b() == Item.func_150898_a((Block)((Block)object));
            }
        }
        return item && meta && nbt && size;
    }

    public int hashCode() {
        if (this.itemStack != null) {
            int hashCode = 1;
            hashCode = 31 * hashCode + this.itemStack.func_77973_b().hashCode();
            if (this.meta_compare) {
                hashCode = 31 * hashCode + this.itemStack.func_77960_j();
            }
            if (this.stack_size) {
                hashCode = 31 * hashCode + this.itemStack.field_77994_a;
            }
            if (this.nbt_compare) {
                hashCode = 31 * hashCode + (this.itemStack.func_77978_p() != null ? this.itemStack.func_77978_p().hashCode() : 0);
            }
            return hashCode;
        }
        return super.hashCode();
    }

    public String toString() {
        return "ItemStackWrapper[" + this.itemStack + "]";
    }
}

