/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.data.heat;

import com.builtbroken.jlib.data.science.units.TemperatureUnit;
import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.lib.data.heat.BlockConversionData;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.lib.world.map.heat.HeatDataManager;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class HeatedBlockRegistry {
    public static HashMap<Block, BlockConversionData> warm_up_conversion = new HashMap();
    public static HashMap<Block, BlockConversionData> cool_down_conversion = new HashMap();
    public static HashMap<Material, Integer> default_melting_point_mat = new HashMap();
    public static HashMap<Material, Integer> default_temp_mat = new HashMap();
    public static HashMap<Material, Float> default_specific_heat_mat = new HashMap();
    public static HashMap<Material, Float> default_fusion_heat_mat = new HashMap();
    public static HashMap<Material, Float> default_vaporization_mat = new HashMap();
    public static HashMap<Integer, Integer> default_temp_dim = new HashMap();

    public static float getEnergyNeededToHeat(World world, BlockPos pos, int newTemp) {
        Block block = pos.getBlock(world);
        if (block != null) {
            float mass = (float)VoltzEngineAPI.massRegistry.getMass(block);
            int actual_temp = HeatDataManager.getTempKelvin(world, pos.x, pos.y, pos.z);
            float change = TemperatureUnit.Celsius.conversion.fromKelvin((float)Math.abs(actual_temp - newTemp));
            if (change >= 1.0f) {
                if (newTemp > actual_temp) {
                    return HeatedBlockRegistry.getSpecificHeat(block) * mass * change;
                }
                return -HeatedBlockRegistry.getSpecificHeat(block) * mass * change;
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public static void addNewHeatingConversion(Block block, Block result, int kelvin) {
        HeatedBlockRegistry.addNewHeatingConversion(block, new PlacementData(result, -1), kelvin);
    }

    public static void addNewHeatingConversion(Block block, PlacementData result, int kelvin) {
        HeatedBlockRegistry.addNewHeatingConversion(new PlacementData(block, -1), result, kelvin);
    }

    public static void addNewHeatingConversion(PlacementData block, PlacementData result, int kelvin) {
        if (warm_up_conversion.containsKey(block.block())) {
            Engine.logger().error("HeatedBlockRegistry: Block[" + (Object)((Object)block) + "] conversion to " + warm_up_conversion.get(block.block()) + " is being replaced by " + (Object)((Object)result));
        }
        warm_up_conversion.put(block.block(), new BlockConversionData(block, result, kelvin));
    }

    public static void addNewCoolingConversion(Block block, Block result, int kelvin) {
        HeatedBlockRegistry.addNewCoolingConversion(block, new PlacementData(result, -1), kelvin);
    }

    public static void addNewCoolingConversion(Block block, PlacementData result, int kelvin) {
        HeatedBlockRegistry.addNewCoolingConversion(new PlacementData(block, -1), result, kelvin);
    }

    public static void addNewCoolingConversion(PlacementData block, PlacementData result, int kelvin) {
        if (cool_down_conversion.containsKey(block.block())) {
            Engine.logger().error("HeatedBlockRegistry: Block[" + (Object)((Object)block) + "] conversion to " + warm_up_conversion.get(block.block()) + " is being replaced by " + (Object)((Object)result));
        }
        cool_down_conversion.put(block.block(), new BlockConversionData(block, result, kelvin));
    }

    public static float getSpecificHeat(Block block) {
        if (default_specific_heat_mat.containsKey(block.field_149764_J)) {
            return default_specific_heat_mat.get(block.field_149764_J).floatValue();
        }
        return 1.0f;
    }

    public static PlacementData getResult(Block block) {
        BlockConversionData conversion = HeatedBlockRegistry.getWarnUpData(block);
        if (conversion != null) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static PlacementData getResultWarmUp(Block block, int temp) {
        BlockConversionData conversion = HeatedBlockRegistry.getWarnUpData(block);
        if (conversion != null && conversion.temp_kelvin <= temp) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static PlacementData getResultCoolDown(Block block, int temp) {
        BlockConversionData conversion = HeatedBlockRegistry.getCoolDownData(block);
        if (conversion != null && conversion.temp_kelvin >= temp) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static BlockConversionData getWarnUpData(Block block) {
        if (warm_up_conversion.containsKey(block)) {
            return warm_up_conversion.get(block);
        }
        return null;
    }

    public static BlockConversionData getCoolDownData(Block block) {
        if (cool_down_conversion.containsKey(block)) {
            return cool_down_conversion.get(block);
        }
        return null;
    }

    public static int getDefaultTemp(World world, Block block) {
        Material mat = block.func_149688_o();
        if (default_temp_mat.containsKey(mat)) {
            return default_temp_mat.get(mat);
        }
        if (default_temp_dim.containsKey(world.field_73011_w.field_76574_g)) {
            return default_temp_dim.get(world.field_73011_w.field_76574_g);
        }
        return 293;
    }

    public static void init(Configuration config) {
        config.setCategoryComment("Block_Heat_Conversions", "Conversion of one block into another when a lot of heat is added. 'Air' as an entry means the block turned into dust");
        HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150432_aD, Blocks.field_150355_j, (int)TemperatureUnit.Fahrenheit.conversion.toKelvin(32.0f));
        HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150343_Z, Blocks.field_150353_l, 1293);
        HeatedBlockRegistry.addNewHeatingConversion((Block)Blocks.field_150349_c, Blocks.field_150346_d, 600);
        HeatedBlockRegistry.addNewCoolingConversion(Blocks.field_150355_j, Blocks.field_150432_aD, 273);
        HeatedBlockRegistry.addNewCoolingConversion(Blocks.field_150353_l, Blocks.field_150343_Z, 1200);
        if (Block.field_149771_c instanceof FMLControlledNamespacedRegistry) {
            FMLControlledNamespacedRegistry reg = (FMLControlledNamespacedRegistry)Block.field_149771_c;
            for (Object obj : reg.typeSafeIterable()) {
                if (!(obj instanceof Block)) continue;
                String name = reg.func_148750_c(obj);
                Material mat = ((Block)obj).func_149688_o();
                Block blockToConvertTo = Blocks.field_150350_a;
                int temp = 0;
                if (mat.func_76217_h()) {
                    temp = 600;
                } else if (mat == Material.field_151576_e) {
                    temp = 1293;
                    blockToConvertTo = Blocks.field_150353_l;
                }
                if (temp <= 0) continue;
                String conversion = config.getString(name, "Heat_Conversions", reg.func_148750_c((Object)blockToConvertTo), "");
                if (reg.func_82594_a(conversion) != null) {
                    Object c_obj = reg.func_82594_a(conversion);
                    if (c_obj instanceof Block) {
                        if (warm_up_conversion.containsKey(obj)) continue;
                        if (blockToConvertTo == Blocks.field_150353_l) {
                            HeatedBlockRegistry.addNewHeatingConversion((Block)obj, new PlacementData(Blocks.field_150347_e, 0), temp);
                            continue;
                        }
                        HeatedBlockRegistry.addNewHeatingConversion((Block)obj, (Block)c_obj, temp);
                        continue;
                    }
                    Engine.logger().error("Error c_obj is not an instance of a block");
                    continue;
                }
                Engine.logger().error("Config entry for heat conversion " + name + " has an invalid conversion of " + conversion);
            }
        }
    }

    static {
        default_temp_dim.put(1, 327);
        default_temp_dim.put(0, 293);
        default_temp_dim.put(-1, 227);
        default_melting_point_mat.put(Material.field_151593_r, 600);
        default_melting_point_mat.put(Material.field_151580_n, 600);
        default_melting_point_mat.put(Material.field_151575_d, 800);
        default_melting_point_mat.put(Material.field_151576_e, 1200);
        default_melting_point_mat.put(Material.field_151571_B, 2000);
        default_melting_point_mat.put(Material.field_151574_g, 1900);
        default_melting_point_mat.put(Material.field_151573_f, 1900);
        default_melting_point_mat.put(Material.field_151586_h, 373);
        default_melting_point_mat.put(Material.field_151597_y, 273);
        default_melting_point_mat.put(Material.field_151588_w, 273);
        default_melting_point_mat.put(Material.field_151598_x, 273);
        default_melting_point_mat.put(Material.field_151596_z, 273);
        default_temp_mat.put(Material.field_151588_w, 253);
        default_temp_mat.put(Material.field_151598_x, 253);
        default_temp_mat.put(Material.field_151597_y, 253);
        default_temp_mat.put(Material.field_151596_z, 253);
    }
}

