/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.imp.transform.region;

import com.builtbroken.mc.imp.transform.region.Shape3D;
import com.builtbroken.mc.imp.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Sphere
extends Shape3D {
    double r;

    public Sphere(Pos pos, double r) {
        super(pos);
        this.r = r;
    }

    @Override
    public double getSizeX() {
        return this.r * 2.0;
    }

    @Override
    public double getSizeY() {
        return this.r * 2.0;
    }

    @Override
    public double getSizeZ() {
        return this.r * 2.0;
    }

    @Override
    public double getArea() {
        return Math.PI * 4 * (this.r * this.r);
    }

    @Override
    public double getVolume() {
        return Math.PI * 4 * (this.r * this.r * this.r) / 3.0;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return ((Pos)new Pos(x, y, z).subtract(x, y, z)).magnitude() <= this.r;
    }

    public <E extends Entity> List<E> getEntities(World world, Class<E> clazz) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        int minX = MathHelper.func_76128_c((double)((this.r - World.MAX_ENTITY_RADIUS) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((this.r + World.MAX_ENTITY_RADIUS) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((this.r - World.MAX_ENTITY_RADIUS) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((this.r + World.MAX_ENTITY_RADIUS) / 16.0));
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                int chunkX = dx + (this.center.xi() >> 4);
                int chunkZ = dz + (this.center.zi() >> 4);
                if (!world.func_72863_F().func_73149_a(chunkX, chunkZ)) continue;
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                int yStart = MathHelper.func_76128_c((double)((this.r - World.MAX_ENTITY_RADIUS + (double)this.center.yi()) / 16.0));
                int yEnd = MathHelper.func_76128_c((double)((this.r + World.MAX_ENTITY_RADIUS + (double)this.center.yi()) / 16.0));
                yStart = MathHelper.func_76125_a((int)yStart, (int)0, (int)(chunk.field_76645_j.length - 1));
                yEnd = MathHelper.func_76125_a((int)yEnd, (int)0, (int)(chunk.field_76645_j.length - 1));
                for (int k = yStart; k <= yEnd; ++k) {
                    List list1 = chunk.field_76645_j[k];
                    for (int l = 0; l < list1.size(); ++l) {
                        Entity entity = (Entity)list1.get(l);
                        if (clazz != null && !clazz.isAssignableFrom(entity.getClass())) continue;
                        Pos pos = new Pos(entity);
                        if (!(this.distance(pos) <= this.r)) continue;
                        list.add(entity);
                    }
                }
            }
        }
        return list;
    }
}

