/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.thread.action;

import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeLayeredAction;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.WorldChangeActionEvent;
import com.builtbroken.mc.api.process.IThreadProcess;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.thread.action.WorldActionQue;
import com.builtbroken.mc.framework.thread.action.WorldChangeActionPost;
import com.builtbroken.mc.framework.thread.action.WorldEditQueue;
import com.builtbroken.mc.imp.transform.vector.Location;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public class WCAThreadProcess
implements IThreadProcess {
    public final Location position;
    public final IWorldChangeAction blast;
    public final TriggerCause triggerCause;
    public int blocksPerTick;
    private Collection<IWorldEdit> effectedBlocks;
    public List<LayerDebugData> layerDebugData;

    public WCAThreadProcess(Location vec, IWorldChangeAction blast, TriggerCause triggerCause) {
        this.position = vec;
        this.blast = blast;
        this.triggerCause = triggerCause;
        this.blocksPerTick = blast.shouldThreadAction();
    }

    @Override
    public void runProcess() {
        try {
            if (this.blast instanceof IWorldChangeLayeredAction && ((IWorldChangeLayeredAction)((Object)this.blast)).getLayers() > 1) {
                for (int i = 0; i < ((IWorldChangeLayeredAction)((Object)this.blast)).getLayers() && ((IWorldChangeLayeredAction)((Object)this.blast)).shouldContinueAction(i); ++i) {
                    long time = System.nanoTime();
                    this.effectedBlocks = new ArrayList<IWorldEdit>();
                    ((IWorldChangeLayeredAction)((Object)this.blast)).getEffectedBlocks((List)this.effectedBlocks, i);
                    if (Engine.runningAsDev) {
                        time = System.nanoTime() - time;
                        if (this.layerDebugData == null) {
                            this.layerDebugData = new ArrayList<LayerDebugData>();
                        }
                        LayerDebugData data = new LayerDebugData();
                        data.layer = i;
                        data.blocksEdited = this.effectedBlocks.size();
                        data.timeProcessedNano = time;
                        this.layerDebugData.add(data);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(this.position, this.effectedBlocks, this.blast, this.triggerCause));
                    WorldActionQue.addEditQue(new WorldEditQueue(this.position.world, this.blast, this.blocksPerTick, this.effectedBlocks));
                }
                if (Engine.runningAsDev && this.layerDebugData.size() > 0) {
                    long time = 0L;
                    long blocks = 0L;
                    for (LayerDebugData data : this.layerDebugData) {
                        time += data.timeProcessedNano;
                        blocks += (long)data.blocksEdited;
                    }
                    Engine.logger().info(this + " ran " + this.layerDebugData.size() + " layers in " + StringHelpers.formatNanoTime((long)time) + " edit " + blocks + " blocks with an average of " + StringHelpers.formatNanoTime((long)(time / (long)this.layerDebugData.size())) + " per layer");
                }
            } else {
                this.effectedBlocks = this.blast.getEffectedBlocks();
                MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(this.position, this.effectedBlocks, this.blast, this.triggerCause));
                WorldActionQue.addEditQue(new WorldEditQueue(this.position.world, this.blast, this.blocksPerTick, this.effectedBlocks));
            }
            WorldActionQue.addEditQue(new WorldChangeActionPost(this.blast));
        }
        catch (Exception e) {
            Engine.logger().error("World Change action thread[" + this + "] has failed to execute correctly.", (Throwable)e);
        }
    }

    @Override
    public void killAction() {
        this.blast.killAction(false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WCAThreadProcess) {
            if (((WCAThreadProcess)obj).position != this.position) {
                return false;
            }
            if (((WCAThreadProcess)obj).blast != this.blast) {
                return false;
            }
            if (((WCAThreadProcess)obj).triggerCause != this.triggerCause) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "WCAThreadProcess[" + this.position + " || " + this.blast + "]@" + this.hashCode();
    }

    public static class LayerDebugData {
        public int layer;
        public int blocksEdited;
        public long timeProcessedNano;

        public String toString() {
            return "Layer[" + this.layer + "] edited " + this.blocksEdited + " tiles, took " + StringHelpers.formatNanoTime((long)this.timeProcessedNano);
        }
    }
}

