/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.thread;

import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.api.process.IThreadProcess;
import com.builtbroken.mc.api.process.IWorkerThread;
import com.builtbroken.mc.core.Engine;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkerThread
extends Thread
implements IWorkerThread {
    private Queue<IThreadProcess> queue = new ConcurrentLinkedQueue<IThreadProcess>();
    private boolean waiting = false;
    private boolean kill = false;
    private boolean paused = false;
    private IThreadProcess currentProcess;

    public WorkerThread(String name) {
        super("WorkerThread[" + name + "]");
        this.setPriority(5);
        VoltzEngineAPI.WORKER_THREADS.put(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                while (!this.kill) {
                    if (this.paused) {
                        this.wait(100L);
                    }
                    if (this.queue.size() > 0) {
                        this.currentProcess = this.queue.poll();
                        this.currentProcess.runProcess();
                        continue;
                    }
                    try {
                        this.waiting = true;
                        WorkerThread workerThread = this;
                        synchronized (workerThread) {
                            this.wait(1000L);
                        }
                    }
                    catch (IllegalMonitorStateException e) {
                        Engine.logger().error(this + " has failed and is terminating...", (Throwable)e);
                        this.kill = true;
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
            catch (Exception e) {
                Engine.logger().error("World Change action thread[" + this + "] has failed to execute correctly.", (Throwable)e);
            }
            finally {
                if (this.queue.size() <= 0) break block15;
                Engine.logger().info("Killing " + this + " with processes left to run...");
                for (IThreadProcess process : this.queue) {
                    Engine.logger().info("\t" + process);
                    process.killAction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(IThreadProcess process) {
        if (!this.contains(process)) {
            this.queue.add(process);
            if (this.waiting) {
                WorkerThread workerThread = this;
                synchronized (workerThread) {
                    this.waiting = false;
                    this.notify();
                }
            }
        }
    }

    @Override
    public boolean contains(IThreadProcess process) {
        return this.queue.contains(process);
    }

    @Override
    public int containedProcesses() {
        return this.queue.size();
    }

    @Override
    public void kill() {
        this.kill = true;
        if (this.currentProcess != null) {
            this.currentProcess.killAction();
        }
    }

    @Override
    public boolean clearProcesses() {
        if (this.currentProcess != null) {
            this.currentProcess.killAction();
        }
        this.queue.clear();
        return this.queue.isEmpty();
    }

    @Override
    public boolean pauseWorker() {
        this.paused = true;
        return this.paused;
    }

    @Override
    public boolean resumeWorker() {
        this.paused = false;
        return !this.paused;
    }
}

