/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.multiblock;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.api.tile.provider.ITankProvider;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.handler.TileTaskTickHandler;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;

public class TileMulti
extends TileEntity
implements IMultiTile,
IPacketIDReceiver {
    private WeakReference<IMultiTileHost> hostWeakReference;
    public boolean shouldRenderBlock = false;
    public Cube overrideRenderBounds;
    public Cube collisionBounds;
    public int ticks = 0;
    public HashMap<ForgeDirection, Block> connectedBlocks = new HashMap();

    @Override
    public IMultiTileHost getHost() {
        return this.hostWeakReference != null ? (IMultiTileHost)this.hostWeakReference.get() : null;
    }

    public boolean canUpdate() {
        return DimensionManager.getWorld((int)0) != null;
    }

    @Override
    public void setHost(IMultiTileHost host) {
        this.hostWeakReference = new WeakReference<IMultiTileHost>(host);
        if (host == null && this.field_145850_b != null && !this.field_145850_b.field_147482_g.contains(this)) {
            this.field_145850_b.addTileEntity((TileEntity)this);
        }
        if (!this.field_145850_b.field_72995_K) {
            Engine.packetHandler.sendToAllAround((IPacket)this.getDescPacket(), this);
        }
    }

    public void func_145843_s() {
        if (this.getHost() != null) {
            this.getHost().onTileInvalidate(this);
        }
        super.func_145843_s();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.ticks == 0) {
            this.updateConnections();
        }
        if (!this.field_145850_b.field_72995_K && this.ticks % 20 == 0) {
            if (this.getHost() == null) {
                this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.func_145831_w().field_147482_g.contains(this)) {
                TileTaskTickHandler.INSTANCE.addTileToBeRemoved(this);
            }
        }
        ++this.ticks;
    }

    public void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Pos pos = (Pos)((Object)new Pos(this).add(dir));
            Block b = pos.getBlock((IBlockAccess)this.func_145831_w());
            if (this.connectedBlocks.containsKey(dir) && this.connectedBlocks.get(dir) != b) {
                this.connectedBlocks.remove(dir);
            }
            if (b == null || b.isAir((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue;
            this.connectedBlocks.put(dir, b);
        }
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.field_145850_b.field_72995_K && id == 1) {
            Pos pos = new Pos(buf);
            if (pos.isZero()) {
                this.setHost(null);
            } else {
                TileEntity tile = pos.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tile instanceof IMultiTileHost) {
                    this.setHost((IMultiTileHost)tile);
                }
            }
            boolean prev = this.shouldRenderBlock;
            this.shouldRenderBlock = buf.readBoolean();
            this.overrideRenderBounds = buf.readBoolean() ? new Cube(buf) : new Cube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            if (prev != this.shouldRenderBlock) {
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public Packet func_145844_m() {
        return Engine.packetHandler.toMCPacket(this.getDescPacket());
    }

    public PacketTile getDescPacket() {
        Pos pos;
        Pos pos2 = pos = this.getHost() != null ? new Pos(this.getHost()) : new Pos();
        if (this.overrideRenderBounds != null) {
            return new PacketTile(this, new Object[]{1, pos, this.shouldRenderBlock, true, this.overrideRenderBounds});
        }
        return new PacketTile(this, new Object[]{1, pos, this.shouldRenderBlock, false});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ DIM@" + (this.field_145850_b != null && this.field_145850_b.field_73011_w != null ? this.field_145850_b.field_73011_w.field_76574_g + " " : "null ") + this.field_145851_c + "x " + this.field_145848_d + "y " + this.field_145849_e + "z ]@" + this.hashCode();
    }

    public IFluidTank getTank(Fluid fluid) {
        IMultiTileHost host = this.getHost();
        if (host != null) {
            if (host instanceof ITileNodeHost && ((ITileNodeHost)((Object)host)).getTileNode() instanceof ITankProvider) {
                return ((ITankProvider)((Object)((ITileNodeHost)((Object)host)).getTileNode())).getTankForFluid(fluid);
            }
            if (host instanceof ITankProvider) {
                return ((ITankProvider)((Object)host)).getTankForFluid(fluid);
            }
        }
        return null;
    }
}

