/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.multiblock;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.TileMulti;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockHelper {
    private static final Logger logger = LogManager.getLogger((String)"VE-MultiBlockHelper");

    public static void buildMultiBlock(World world, IMultiTileHost tile) {
        MultiBlockHelper.buildMultiBlock(world, tile, false, false);
    }

    public static void buildMultiBlock(World world, IMultiTileHost tile, boolean validate) {
        MultiBlockHelper.buildMultiBlock(world, tile, validate, false);
    }

    public static void buildMultiBlock(World world, IMultiTileHost tile, boolean validate, boolean offset) {
        if (world == null) {
            logger.error("MultiBlockHelper: buildMultiBlock was called with a null world by " + tile, (Throwable)new RuntimeException());
            return;
        }
        if (tile == null) {
            logger.error("MultiBlockHelper: buildMultiBlock was called with a null tile ", (Throwable)new RuntimeException());
            return;
        }
        if (Engine.multiBlock != null) {
            HashMap<IPos3D, String> map = tile.getLayoutOfMultiBlock();
            if (map != null && !map.isEmpty()) {
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    EnumMultiblock enumType;
                    IPos3D location = (IPos3D)entry.getKey();
                    String type = (String)entry.getValue();
                    String dataString = null;
                    if (location == null) {
                        logger.error("MultiBlockHelper: location[" + i + "] is null, this is most likely in error in " + tile);
                        ++i;
                        continue;
                    }
                    if (type == null) {
                        logger.error("MultiBlockHelper: type[" + i + "] is null, this is most likely in error in " + tile);
                        ++i;
                        continue;
                    }
                    if (type.isEmpty()) {
                        logger.error("MultiBlockHelper: type[" + i + "] is empty, this is most likely in error in " + tile);
                        ++i;
                        continue;
                    }
                    if (type.contains("#")) {
                        dataString = type.substring(type.indexOf("#") + 1, type.length());
                        type = type.substring(0, type.indexOf("#"));
                    }
                    if ((enumType = EnumMultiblock.get(type)) != null) {
                        if (offset) {
                            location = (IPos3D)new Location((World)tile.world().unwrap(), tile.x(), tile.y(), tile.z()).add(location);
                        }
                        TileEntity ent = world.func_147438_o(location.xi(), location.yi(), location.zi());
                        if (!validate || ent == null || enumType.clazz != ent.getClass()) {
                            if (!world.func_147465_d(location.xi(), location.yi(), location.zi(), Engine.multiBlock, enumType.ordinal(), 3)) {
                                logger.error("MultiBlockHelper: type[" + i + ", " + type + "] error block was not placed ");
                            }
                            ent = world.func_147438_o(location.xi(), location.yi(), location.zi());
                        }
                        if (ent instanceof IMultiTile) {
                            ((IMultiTile)ent).setHost(tile);
                            MultiBlockHelper.setData(dataString, (IMultiTile)ent);
                        } else {
                            logger.error("MultiBlockHelper: type[" + i + ", " + type + "] tile at location is not IMultiTile, " + ent);
                        }
                    } else {
                        logger.error("MultiBlockHelper: type[" + i + ", " + type + "] is not a invalid multi tile type, this is most likely an error in " + tile);
                    }
                    ++i;
                }
            } else {
                logger.error("Tile[" + tile + "] didn't return a structure map");
            }
        } else {
            logger.error("MultiBlock was never registered, this is a critical error and can have negative effects on gameplay. Make sure the block was not disabled in the configs and contact support to ensure nothing is broken", (Throwable)new RuntimeException());
        }
    }

    public static boolean canBuild(IBlockAccess world, IMultiTileHost tile, boolean offset) {
        if (world != null && tile != null && Engine.multiBlock != null) {
            HashMap<IPos3D, String> map = tile.getLayoutOfMultiBlock();
            return MultiBlockHelper.canBuild(world, tile.xi(), tile.yi(), tile.zi(), tile, map, offset);
        }
        return false;
    }

    public static boolean canBuild(IBlockAccess world, int x, int y, int z, IMultiTileHost tile, Map<IPos3D, String> map, boolean offset) {
        if (world != null && Engine.multiBlock != null && map != null && !map.isEmpty()) {
            for (Map.Entry<IPos3D, String> entry : map.entrySet()) {
                TileEntity tileEntity;
                Block block;
                EnumMultiblock enumType;
                IPos3D location = entry.getKey();
                String type = entry.getValue();
                String dataString = null;
                if (location == null || type == null || type.isEmpty()) {
                    return false;
                }
                if (type.contains("#")) {
                    dataString = type.substring(type.indexOf("#") + 1, type.length());
                    type = type.substring(0, type.indexOf("#"));
                }
                if ((enumType = EnumMultiblock.get(type)) == null) continue;
                if (offset) {
                    location = (IPos3D)new Pos(x, y, z).add(location);
                }
                if (!(block = world.func_147439_a(location.xi(), location.yi(), location.zi())).isAir(world, location.xi(), location.yi(), location.zi()) && !block.isReplaceable(world, location.xi(), location.yi(), location.zi())) {
                    return false;
                }
                if (block != Engine.multiBlock || !((tileEntity = world.func_147438_o(location.xi(), location.yi(), location.zi())) instanceof IMultiTile) || ((IMultiTile)tileEntity).getHost() == null || ((IMultiTile)tileEntity).getHost() == tile) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void setData(String dataString, IMultiTile ent) {
        if (ent instanceof TileMulti && dataString != null && !dataString.isEmpty()) {
            String[] data = dataString.contains("|") ? dataString.split("|") : new String[]{dataString};
            for (String d : data) {
                if (d.contains("=")) {
                    String lowerCase = d.toLowerCase();
                    String value = lowerCase.substring(lowerCase.indexOf("=") + 1, lowerCase.length());
                    if (lowerCase.startsWith("renderblock")) {
                        if (!value.equals("true")) continue;
                        ((TileMulti)ent).shouldRenderBlock = true;
                        continue;
                    }
                    if (lowerCase.startsWith("bounds")) {
                        if (value.contains("{") && value.contains("}") && value.contains(",")) {
                            String[] values = value.split(",");
                            if (values.length != 6) continue;
                            double[] ints = new double[6];
                            boolean failed = false;
                            for (int se = 0; se < 6; ++se) {
                                try {
                                    ints[se] = Double.parseDouble(values[se].replace("f", ""));
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    failed = true;
                                    break;
                                }
                            }
                            if (failed) continue;
                            if (((TileMulti)ent).func_145831_w().field_72995_K) {
                                ((TileMulti)ent).overrideRenderBounds = new Cube(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]);
                            }
                            ((TileMulti)ent).collisionBounds = new Cube(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]);
                            continue;
                        }
                        logger.error("Tile[" + ent + "] failed to parse bounds data " + d + " as it missing '{', '}, or ',");
                        continue;
                    }
                    logger.error("Tile[" + ent + "] didn't parse " + d);
                    continue;
                }
                logger.error("Tile[" + ent + "] failed to parse " + d + " as it doesn't contain '='");
            }
        } else if (!(ent instanceof TileMulti)) {
            logger.error("Tile[" + ent + "] needs to be an instanceof TileMulti in order to set data");
        }
    }

    @Deprecated
    public static void destroyMultiBlockStructure(IMultiTileHost host) {
        MultiBlockHelper.destroyMultiBlockStructure(host, true);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops) {
        MultiBlockHelper.destroyMultiBlockStructure(host, doDrops, false);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops, boolean offset) {
        MultiBlockHelper.destroyMultiBlockStructure(host, doDrops, offset, true);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops, boolean offset, boolean killHost) {
        if (host != null) {
            HashMap<IPos3D, String> map = host.getLayoutOfMultiBlock();
            if (map != null && !map.isEmpty()) {
                IWorldPosition center;
                if (host instanceof TileEntity) {
                    center = new Location((TileEntity)host);
                } else if (host instanceof IWorldPosition) {
                    center = (IWorldPosition)((Object)host);
                } else {
                    logger.error("MultiBlockHelper >> Tile[" + host + "]'s is not a TileEntity or IWorldPosition instance, thus we can not get a position to break down the structure.");
                    return;
                }
                for (Map.Entry<IPos3D, String> entry : map.entrySet()) {
                    TileEntity tile;
                    Pos pos;
                    Pos pos2 = pos = entry.getKey() instanceof Pos ? (Pos)entry.getKey() : new Pos(entry.getKey());
                    if (offset) {
                        pos = (Pos)pos.add(center);
                    }
                    if (!((tile = pos.getTileEntity((IBlockAccess)center.oldWorld())) instanceof IMultiTile)) continue;
                    ((IMultiTile)tile).setHost(null);
                    pos.setBlockToAir(center.oldWorld());
                }
                if (doDrops) {
                    InventoryUtility.dropBlockAsItem(center, killHost);
                } else if (killHost) {
                    center.oldWorld().func_147468_f(center.xi(), center.yi(), center.zi());
                }
            } else {
                logger.error("MultiBlockHelper >> Tile[" + host + "]'s structure map is empty");
            }
        }
    }

    public static void updateStructure(World world, IMultiTileHost host, boolean offset) {
        HashMap<IPos3D, String> map;
        if (!(host instanceof TileEntity)) {
            Engine.error("Tile host is not an instance of TileEntity");
        }
        if (world == null) {
            Engine.error("Tile host is not an instance of TileEntity");
        }
        if ((map = host.getLayoutOfMultiBlock()) != null && !map.isEmpty()) {
            int x = ((TileEntity)host).field_145851_c;
            int y = ((TileEntity)host).field_145848_d;
            int z = ((TileEntity)host).field_145849_e;
            Pos center = new Pos(x, y, z);
            for (Map.Entry<IPos3D, String> entry : map.entrySet()) {
                Location pos = new Location(world, entry.getKey());
                if (offset) {
                    pos = (Location)pos.add(center);
                }
                pos.markForUpdate();
            }
            center.markForUpdate(world);
        } else {
            logger.error("Tile[" + host + "]'s structure map is empty");
        }
    }

    public static List<Chunk> getChunks(World world, IMultiTileHost host, boolean offset) {
        HashMap<IPos3D, String> map;
        if (!(host instanceof TileEntity)) {
            Engine.error("Tile host is not an instance of TileEntity");
        }
        if ((map = host.getLayoutOfMultiBlock()) != null && !map.isEmpty()) {
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (Map.Entry<IPos3D, String> entry : map.entrySet()) {
                Location pos = new Location(world, entry.getKey());
                if (offset) {
                    pos = (Location)pos.add(((TileEntity)host).field_145851_c, ((TileEntity)host).field_145848_d, ((TileEntity)host).field_145849_e);
                }
                if (chunks.contains(pos.getChunk())) continue;
                chunks.add(pos.getChunk());
            }
            return chunks;
        }
        Engine.error("Tile host[" + host + "] did have a map");
        return new ArrayList<Chunk>();
    }
}

