/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.mod.loadable;

import com.builtbroken.mc.framework.mod.loadable.ILoadable;
import com.builtbroken.mc.framework.mod.loadable.ILoadableProxy;
import com.builtbroken.mc.framework.mod.loadable.LoadWithMod;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LoadableHandler {
    private HashMap<ILoadable, List<LoadPhase>> loadables = new HashMap();
    private LoadPhase phase = LoadPhase.PRELAUNCH;
    private List<ILoadable> waitingToBeAdded = new ArrayList<ILoadable>();
    private boolean running = false;

    public void applyModule(Class<?> clazz) {
        this.applyModule(clazz, true);
    }

    public void applyModule(Class<?> clazz, boolean load2) {
        if (load2) {
            String id;
            if (clazz.getAnnotation(LoadWithMod.class) != null && !Loader.isModLoaded((String)(id = clazz.getAnnotation(LoadWithMod.class).mod_id()))) {
                return;
            }
            try {
                Object module = clazz.newInstance();
                if (module instanceof ILoadableProxy) {
                    ILoadableProxy subProxy = (ILoadableProxy)module;
                    if (subProxy.shouldLoad()) {
                        this.loadables.put(subProxy, new ArrayList());
                    }
                } else if (module instanceof ILoadable) {
                    this.loadables.put((ILoadable)module, new ArrayList());
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyModule(ILoadable module) {
        if (this.phase == LoadPhase.DONE || this.phase == LoadPhase.LOAD_COMPLETE && this.running) {
            throw new RuntimeException("Module '" + module + "' was added to late into loading phase to be added!!! To prevent damage to the game and saves the game will be closed.");
        }
        List<ILoadable> list = this.waitingToBeAdded;
        synchronized (list) {
            if (this.running) {
                this.waitingToBeAdded.add(module);
            } else {
                this.loadables.put(module, new ArrayList());
            }
        }
    }

    public void preInit() {
        this.load(LoadPhase.PREINIT);
    }

    public void init() {
        this.load(LoadPhase.INIT);
    }

    public void postInit() {
        this.load(LoadPhase.POSTINIT);
    }

    public void loadComplete() {
        this.load(LoadPhase.LOAD_COMPLETE);
        this.phase = LoadPhase.DONE;
    }

    protected void load(LoadPhase untilPhase) {
        this.running = true;
        this.phase = untilPhase;
        if (!this.waitingToBeAdded.isEmpty()) {
            for (ILoadable l : this.waitingToBeAdded) {
                this.loadables.put(l, new ArrayList());
            }
            this.waitingToBeAdded.clear();
        }
        for (Map.Entry<ILoadable, List<LoadPhase>> proxy : this.loadables.entrySet()) {
            if (untilPhase.ordinal() < LoadPhase.PREINIT.ordinal()) continue;
            if (!proxy.getValue().contains((Object)LoadPhase.PREINIT)) {
                proxy.getValue().add(LoadPhase.PREINIT);
                proxy.getKey().preInit();
            }
            if (untilPhase.ordinal() < LoadPhase.INIT.ordinal()) continue;
            if (!proxy.getValue().contains((Object)LoadPhase.INIT)) {
                proxy.getValue().add(LoadPhase.INIT);
                proxy.getKey().init();
            }
            if (untilPhase.ordinal() < LoadPhase.POSTINIT.ordinal()) continue;
            if (!proxy.getValue().contains((Object)LoadPhase.POSTINIT)) {
                proxy.getValue().add(LoadPhase.POSTINIT);
                proxy.getKey().postInit();
            }
            if (untilPhase.ordinal() < LoadPhase.LOAD_COMPLETE.ordinal() || proxy.getValue().contains((Object)LoadPhase.LOAD_COMPLETE)) continue;
            proxy.getKey().loadComplete();
            proxy.getValue().add(LoadPhase.LOAD_COMPLETE);
        }
        if (!this.waitingToBeAdded.isEmpty()) {
            this.load(untilPhase);
        }
        this.running = false;
    }

    public static enum LoadPhase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        LOAD_COMPLETE,
        DONE;

    }
}

