/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.arrays;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class JsonConverterByteArray
extends JsonConverter<byte[]> {
    public JsonConverterByteArray() {
        super("array.byte", new String[0]);
    }

    @Override
    public byte[] convert(JsonElement element, String ... args) {
        if (element instanceof JsonArray) {
            byte[] array = new byte[element.getAsJsonArray().size()];
            int index = 0;
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    int n = index;
                    index = (byte)(index + 1);
                    array[n] = e.getAsByte();
                    continue;
                }
                throw new IllegalArgumentException("Can not convert object to byte array, as '" + e + "' is not an byte");
            }
            return array;
        }
        return null;
    }
}

