/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.data.transform;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class JsonConverterPos
extends JsonConverter<Pos> {
    public JsonConverterPos() {
        super("pos", new String[0]);
    }

    @Override
    public Pos convert(JsonElement element, String ... args) {
        return JsonConverterPos.fromJson(element);
    }

    public static Pos fromJson(JsonElement element) {
        if (element instanceof JsonObject) {
            return JsonConverterPos.fromJsonObject((JsonObject)element);
        }
        if (element instanceof JsonArray) {
            return JsonConverterPos.fromJsonArray((JsonArray)element);
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return new Pos(primitive.getAsDouble());
            }
            if (primitive.isString()) {
                return new Pos(Double.parseDouble(primitive.getAsString()));
            }
        }
        throw new IllegalArgumentException("JsonConverterPos: could not convert json to pos, json: " + element);
    }

    public static Pos fromJsonObject(JsonObject offsetObject) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (offsetObject.has("x")) {
            x = JsonConverterPos.getNumber(offsetObject.getAsJsonPrimitive("x"));
        }
        if (offsetObject.has("y")) {
            y = JsonConverterPos.getNumber(offsetObject.getAsJsonPrimitive("y"));
        }
        if (offsetObject.has("z")) {
            z = JsonConverterPos.getNumber(offsetObject.getAsJsonPrimitive("z"));
        }
        return new Pos(x, y, z);
    }

    public static double getNumber(JsonPrimitive primitive) {
        if (primitive.isNumber()) {
            return primitive.getAsDouble();
        }
        if (primitive.isString()) {
            return Double.parseDouble(primitive.getAsString());
        }
        throw new IllegalArgumentException("Could not parse value, " + primitive);
    }

    public static Pos fromJsonArray(JsonArray offsetObject) {
        JsonElement there;
        JsonElement two;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        JsonElement one = offsetObject.get(0);
        if (one.isJsonPrimitive()) {
            JsonPrimitive p = one.getAsJsonPrimitive();
            if (p.isNumber()) {
                x = one.getAsDouble();
            } else if (p.isString()) {
                throw new IllegalStateException("Loading json array using strings is not supported yet for pos conversion. Data: " + offsetObject);
            }
        }
        if ((two = offsetObject.get(1)).isJsonPrimitive()) {
            JsonPrimitive p = two.getAsJsonPrimitive();
            if (p.isNumber()) {
                y = two.getAsDouble();
            } else if (p.isString()) {
                throw new IllegalStateException("Loading json array using strings is not supported yet for pos conversion. Data: " + offsetObject);
            }
        }
        if ((there = offsetObject.get(2)).isJsonPrimitive()) {
            JsonPrimitive p = there.getAsJsonPrimitive();
            if (p.isNumber()) {
                x = there.getAsDouble();
            } else if (p.isString()) {
                throw new IllegalStateException("Loading json array using strings is not supported yet for pos conversion. Data: " + offsetObject);
            }
        }
        return new Pos(x, y, z);
    }
}

