/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.data.mc;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterNBT;
import com.builtbroken.mc.framework.json.data.JsonItemEntry;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class JsonConverterItem
extends JsonConverter<JsonItemEntry> {
    public JsonConverterItem() {
        super("item", new String[0]);
    }

    @Override
    public JsonItemEntry convert(JsonElement element, String ... args) {
        return JsonConverterItem.fromJson(element.getAsJsonObject());
    }

    public static JsonItemEntry fromJson(JsonObject itemStackObject) {
        JsonProcessor.ensureValuesExist(itemStackObject, "item");
        JsonItemEntry entry = new JsonItemEntry();
        entry.item = itemStackObject.get("item").getAsString();
        if (itemStackObject.has("meta")) {
            entry.damage = itemStackObject.get("meta").getAsString();
        } else if (itemStackObject.has("damage")) {
            entry.damage = itemStackObject.get("damage").getAsString();
        }
        if (itemStackObject.has("count")) {
            entry.count = itemStackObject.getAsJsonPrimitive("count").getAsInt();
            if (entry.count < 0) {
                throw new RuntimeException("Recipe output count must be above zero");
            }
            if (entry.count > 64) {
                throw new RuntimeException("Recipe output count must be below 64 as this is the max stacksize for this version of Minecraft.");
            }
        }
        if (itemStackObject.has("nbt")) {
            entry.nbt = JsonConverterNBT.handle(itemStackObject.get("nbt"));
            if (entry.nbt.func_82582_d()) {
                entry.nbt = null;
            }
        }
        return entry;
    }
}

