/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.entity.effect.effects;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.entity.effect.EntityEffect;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.entity.damage.DamageBleeding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BleedingEffect
extends EntityEffect {
    public float damage;
    public int duration;
    public Object source;
    public List<BleedingEffect> subEffects = new ArrayList<BleedingEffect>();

    public BleedingEffect(Entity entity) {
        super("voltzengine", "bleeding");
        if (entity != null && entity.field_70170_p != null) {
            this.entity = entity;
            this.world = Engine.getWorld(entity.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    public void setDamageValues(Object source, float damage, int duration) {
        this.source = source;
        this.damage = damage;
        this.duration = duration;
    }

    @Override
    public boolean onWorldTick() {
        if (this.entity instanceof EntityLivingBase && this.entity.func_70089_S() && !this.entity.func_85032_ar()) {
            DamageBleeding damageSource;
            EntityLivingBase entity = (EntityLivingBase)this.entity;
            boolean kill = super.onWorldTick();
            float hp = entity.func_110143_aJ();
            DamageBleeding damageBleeding = damageSource = this.source != null ? new DamageBleeding(this.source) : new DamageBleeding();
            if (hp - this.damage > 0.0f) {
                if (ForgeHooks.onLivingAttack((EntityLivingBase)entity, (DamageSource)damageSource, (float)this.damage)) {
                    return false;
                }
                entity.func_70606_j(hp - this.damage);
            } else {
                entity.field_70172_ad = 0;
                entity.func_70097_a((DamageSource)damageSource, this.damage);
            }
            Iterator<BleedingEffect> it = this.subEffects.iterator();
            while (it.hasNext()) {
                BleedingEffect next = it.next();
                if (next.onWorldTick()) {
                    it.remove();
                    continue;
                }
                if (!kill) continue;
                kill = false;
                this.damage = next.damage;
                this.duration = next.duration;
                this.source = next.source;
                it.remove();
            }
            this.world.newEffect("VEP_bleeding", new Pos(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v)).send();
            return kill || this.duration <= this.tick;
        }
        return true;
    }

    @Override
    public void merge(EntityEffect entityEffect) {
        if (entityEffect.getClass() == this.getClass()) {
            BleedingEffect effect = (BleedingEffect)entityEffect;
            this.subEffects.add(effect);
        }
    }

    @Override
    public void init(Entity entity, World world) {
        super.init(entity, world);
        for (BleedingEffect effect : this.subEffects) {
            effect.init(entity, world);
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74768_a("duration", this.duration);
        compound.func_74776_a("damage", this.damage);
        return super.save(compound);
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.duration = compound.func_74762_e("duration");
        this.damage = compound.func_74760_g("damage");
    }
}

