/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.entity.effect;

import com.builtbroken.jlib.debug.DebugPrinter;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.entity.effect.EntityEffect;
import com.builtbroken.mc.framework.entity.effect.IEEPEntityEffect;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public final class EntityEffectHandler {
    public static final String ENTITY_EXTENDED_PROPERTY_IDENTIFIER = "voltzengine:effecthandler";
    public static final String BLEEDING_EFFECT = "bleeding";
    public static final EntityEffectHandler INSTANCE = new EntityEffectHandler();
    public static boolean doDebug = false;
    private static Map<String, Function<Entity, EntityEffect>> effectCreators = new HashMap<String, Function<Entity, EntityEffect>>();
    private DebugPrinter debugPrinter = new DebugPrinter(Engine.logger());

    private EntityEffectHandler() {
    }

    public static void addEffectCreator(String id, Function<Entity, EntityEffect> function) {
        if (id != null && function != null) {
            effectCreators.put(id.toLowerCase(), function);
        }
    }

    public static void applyEffect(Entity entity, EntityEffect entityEffect) {
        if (entity != null && entityEffect != null) {
            IExtendedEntityProperties prop = entity.getExtendedProperties(ENTITY_EXTENDED_PROPERTY_IDENTIFIER);
            if (!(prop instanceof IEEPEntityEffect)) {
                prop = EntityEffectHandler.createEffectProperty(entity);
            }
            if (prop instanceof IEEPEntityEffect) {
                prop.init(entity, entity.field_70170_p);
                ((IEEPEntityEffect)prop).addEffect(entityEffect);
            }
        }
    }

    public static EntityEffect create(String id, Entity entity) {
        if (effectCreators.containsKey(id.toLowerCase())) {
            return effectCreators.get(id.toLowerCase()).apply(entity);
        }
        return null;
    }

    protected static IEEPEntityEffect createEffectProperty(Entity entity) {
        if (entity != null && entity.field_70170_p != null) {
            IEEPEntityEffect effectProperty = new IEEPEntityEffect();
            entity.registerExtendedProperties(ENTITY_EXTENDED_PROPERTY_IDENTIFIER, (IExtendedEntityProperties)effectProperty);
            effectProperty.init(entity, entity.field_70170_p);
            return effectProperty;
        }
        return null;
    }

    @SubscribeEvent
    public void onEntityCreated(EntityEvent.EntityConstructing event) {
        EntityEffectHandler.createEffectProperty(event.entity);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END) {
            this.debugPrinter.start("EntityEffectHandler", "onWorldTick(" + world.field_73011_w.field_76574_g + ")", doDebug);
            try {
                long time = System.nanoTime();
                ArrayList loadedEntityList = new ArrayList();
                loadedEntityList.addAll(world.field_72996_f);
                time = System.nanoTime() - time;
                this.debugPrinter.log("copy list time: " + StringHelpers.formatNanoTime((long)time));
                time = System.nanoTime();
                for (int i = 0; i < loadedEntityList.size(); ++i) {
                    IExtendedEntityProperties prop;
                    Object object = loadedEntityList.get(i);
                    if (!(object instanceof Entity) || !((prop = ((Entity)object).getExtendedProperties(ENTITY_EXTENDED_PROPERTY_IDENTIFIER)) instanceof IEEPEntityEffect)) continue;
                    try {
                        ((IEEPEntityEffect)prop).onWorldTick();
                        continue;
                    }
                    catch (Exception e) {
                        Engine.logger().error("EntityEffectHandler#onWorldTick(" + event.world.field_73011_w.field_76574_g + ") >> unexpected error updating " + prop + " for " + object, (Throwable)e);
                    }
                }
                time = System.nanoTime() - time;
                this.debugPrinter.log("Entities: " + loadedEntityList.size());
                this.debugPrinter.log("RunTime: " + StringHelpers.formatNanoTime((long)time));
            }
            catch (Exception e) {
                Engine.logger().error("EntityEffectHandler#onWorldTick(" + event.world.field_73011_w.field_76574_g + ") >> unexpected error updating effect providers");
            }
            this.debugPrinter.end();
        }
    }

    public void onEntityDeath(LivingDeathEvent event) {
    }

    public void chunkUnloadEvent(ChunkEvent.Unload event) {
    }

    public void onWorldUnload(WorldEvent.Unload event) {
    }
}

