/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.access.global.packets;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketGui;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.access.AccessGroup;
import com.builtbroken.mc.framework.access.AccessUser;
import com.builtbroken.mc.framework.access.global.GlobalAccessProfile;
import com.builtbroken.mc.framework.access.global.GlobalAccessSystem;
import com.builtbroken.mc.framework.access.perm.Permissions;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PacketAccessGui
extends PacketType
implements IPacket {
    public static int REQUEST_ALL_PROFILES = 0;
    public static int REQUEST_PROFILE = 1;
    public static int KEEP_ALIVE = 2;
    public static int ADD_USER_TO_GROUP = 3;
    public static int REMOVE_USER_FROM_GROUP = 4;
    public static int CREATE_PROFILE = 5;
    public static int CREATE_GROUP = 6;
    public static int REMOVE_GROUP = 7;
    public static int UPDATE_GROUP_PARENT = 9;
    public static int ADD_NODE_TO_GROUP = 10;
    public static int REMOVE_NODE_FROM_GROUP = 11;
    int id = 0;

    public PacketAccessGui() {
    }

    public PacketAccessGui(int id) {
        this.id = id;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.id = buffer.readInt();
        this.data_$eq(buffer.slice());
    }

    @Override
    public void handleServerSide(EntityPlayer e) {
        if (e instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            if (this.id != KEEP_ALIVE) {
                this.sendMessageToClient((EntityPlayer)player, "packet.received");
            }
            if (this.id == REQUEST_ALL_PROFILES) {
                this.clearGui((EntityPlayer)player);
                this.sendProfilesToClient(player);
            } else if (this.id == REQUEST_PROFILE) {
                this.clearGui((EntityPlayer)player);
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                this.sendProfileToClient(player, profileID);
            } else if (this.id == KEEP_ALIVE) {
                this.clearGui((EntityPlayer)player);
                String accessGroup = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(accessGroup);
                if (profile != null) {
                    profile.playersWithSettingsGUIOpen.put((EntityPlayer)player, System.currentTimeMillis());
                }
            } else if (this.id == ADD_USER_TO_GROUP) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String userID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.profileEdit.toString())) {
                        AccessGroup group = profile.getGroup(groupID);
                        if (group != null) {
                            if (group.getMember(userID) != null) {
                                this.sendMessageToClient((EntityPlayer)player, "error.group.user.add.exists");
                            } else if (!group.addMember(userID)) {
                                this.sendMessageToClient((EntityPlayer)player, "error.group.user.add");
                            } else {
                                this.sendProfileToClient(player, profileID);
                            }
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.not.found");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            } else if (this.id == REMOVE_USER_FROM_GROUP) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String userID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.profileEdit.toString())) {
                        AccessGroup group = profile.getGroup(groupID);
                        if (group != null) {
                            if (group.getMember(userID) != null) {
                                if (!group.removeMember(userID)) {
                                    this.sendMessageToClient((EntityPlayer)player, "error.group.user.remove");
                                } else {
                                    this.sendProfileToClient(player, profileID);
                                }
                            } else {
                                this.sendMessageToClient((EntityPlayer)player, "error.group.user.not.found");
                            }
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.not.found");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            } else if (this.id == CREATE_GROUP) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String parentID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.profileAddGroup.toString())) {
                        AccessGroup group = new AccessGroup(groupID, new AccessUser[0]);
                        if (profile.getGroup(groupID) == null) {
                            profile.addGroup(group);
                            AccessGroup parentGroup = profile.getGroup(parentID);
                            if (parentGroup != null) {
                                if (group.setToExtend(parentGroup)) {
                                    this.sendMessageToClient((EntityPlayer)player, "group.parent.set");
                                } else if (group.isParent(parentGroup)) {
                                    this.sendMessageToClient((EntityPlayer)player, "error.group.parent.set.recursive");
                                } else {
                                    this.sendMessageToClient((EntityPlayer)player, "error.group.parent.set");
                                }
                            } else {
                                this.sendMessageToClient((EntityPlayer)player, "error.group.parent.not.found");
                            }
                            this.sendProfileToClient(player, profileID);
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.add.exists");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            } else if (this.id == UPDATE_GROUP_PARENT) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String parentID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.groupSetting.toString())) {
                        AccessGroup group = profile.getGroup(groupID);
                        if (group != null) {
                            if (parentID.trim() == "") {
                                group.setToExtend(null);
                                this.sendMessageToClient((EntityPlayer)player, "group.parent.set");
                                this.sendProfileToClient(player, profileID);
                            } else {
                                AccessGroup parentGroup = profile.getGroup(parentID);
                                if (parentGroup != null) {
                                    if (group.setToExtend(parentGroup)) {
                                        this.sendMessageToClient((EntityPlayer)player, "group.parent.set");
                                        this.sendProfileToClient(player, profileID);
                                    } else if (group.isParent(parentGroup)) {
                                        this.sendMessageToClient((EntityPlayer)player, "error.group.parent.set.recursive");
                                    } else {
                                        this.sendMessageToClient((EntityPlayer)player, "error.group.parent.set");
                                    }
                                } else {
                                    this.sendMessageToClient((EntityPlayer)player, "error.group.parent.not.found");
                                }
                            }
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.not.found");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            } else if (this.id == CREATE_PROFILE) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                boolean defaults = this.data().readBoolean();
                GlobalAccessProfile profile = GlobalAccessSystem.createProfile(profileID, defaults);
                profile.getOwnerGroup().addMember((EntityPlayer)player);
                this.sendProfilesToClient(player);
            } else if (this.id == ADD_NODE_TO_GROUP) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String node = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.groupPermissionAdd.toString())) {
                        AccessGroup group = profile.getGroup(groupID);
                        if (group != null) {
                            if (group.hasExactNode(node)) {
                                group.addNode(node);
                                this.sendProfileToClient(player, profileID);
                            } else {
                                this.sendMessageToClient((EntityPlayer)player, "error.node.exists");
                            }
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.not.found");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            } else if (this.id == REMOVE_NODE_FROM_GROUP) {
                String profileID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String groupID = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                String node = ByteBufUtils.readUTF8String((ByteBuf)this.data());
                GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
                if (profile != null) {
                    if (profile.containsUser((EntityPlayer)player) && profile.hasNode((EntityPlayer)player, Permissions.groupPermissionRemove.toString())) {
                        AccessGroup group = profile.getGroup(groupID);
                        if (group != null) {
                            if (group.hasExactNode(node)) {
                                group.removeNode(node);
                                this.sendProfileToClient(player, profileID);
                            } else {
                                this.sendMessageToClient((EntityPlayer)player, "error.node.not.found");
                            }
                        } else {
                            this.sendMessageToClient((EntityPlayer)player, "error.group.not.found");
                        }
                    } else {
                        this.sendMessageToClient((EntityPlayer)player, "error.profile.access.invalid");
                    }
                } else {
                    this.sendMessageToClient((EntityPlayer)player, "error.profile.not.found");
                }
            }
        }
    }

    protected void sendMessageToClient(EntityPlayer player, String message) {
        PacketGui packetGui = new PacketGui(5);
        ByteBufUtils.writeUTF8String((ByteBuf)packetGui.data(), (String)("" + message));
        Engine.packetHandler.sendToPlayer(packetGui, (EntityPlayerMP)player);
    }

    public void sendProfilesToClient(EntityPlayerMP player) {
        PacketGui packetGui = new PacketGui(0);
        List<GlobalAccessProfile> profileList = GlobalAccessSystem.getProfilesFor((EntityPlayer)player);
        packetGui.data().writeInt(profileList.size());
        for (GlobalAccessProfile profile : profileList) {
            packetGui.write(profile.getName());
            packetGui.write(profile.getID());
            packetGui.write(profile.getUserAccess((EntityPlayer)player).hasNode(Permissions.profileView));
        }
        Engine.packetHandler.sendToPlayer(packetGui, player);
    }

    public void sendProfileToClient(EntityPlayerMP player, String profileID) {
        GlobalAccessProfile profile = GlobalAccessSystem.getProfile(profileID);
        if (profile != null) {
            PacketType packetGui = new PacketGui(1).write(profile.save(new NBTTagCompound()));
            Engine.packetHandler.sendToPlayer(packetGui, player);
        } else {
            PacketGui packetGui = new PacketGui(5);
            ByteBufUtils.writeUTF8String((ByteBuf)packetGui.data(), (String)"error.profile.not.found");
            Engine.packetHandler.sendToPlayer(packetGui, player);
        }
    }

    protected void clearGui(EntityPlayer player) {
        for (GlobalAccessProfile profile : GlobalAccessSystem.getProfiles()) {
            if (profile == null) continue;
            profile.playersWithSettingsGUIOpen.remove(player);
        }
    }

    public static void doRequest() {
        Engine.packetHandler.sendToServer(new PacketAccessGui(REQUEST_ALL_PROFILES));
    }

    public static void doRequest(String profileID) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(REQUEST_PROFILE).write(profileID));
    }

    public static void keepAlive(String profileID) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(KEEP_ALIVE).write(profileID));
    }

    public static void removeUser(String profileID, String group, String userName) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(REMOVE_USER_FROM_GROUP).write(profileID).write(group).write(userName));
    }

    public static void addUser(String profileID, String group, String userName) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(ADD_USER_TO_GROUP).write(profileID).write(group).write(userName));
    }

    public static void createProfile(String name, boolean defaults) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(CREATE_PROFILE).write(name).write(defaults));
    }

    public static void createGroup(String profile, String name, String parent) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(CREATE_GROUP).write(profile).write(name).write(parent));
    }

    public static void updateGroupParent(String profile, String name, String parent) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(UPDATE_GROUP_PARENT).write(profile).write(name).write(parent));
    }

    public static void removeGroup(String profile, String name, boolean pullUpSubGroups) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(REMOVE_GROUP).write(profile).write(name).write(pullUpSubGroups));
    }

    public static void removeNodeFromGroup(String profileID, String group, String node) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(REMOVE_NODE_FROM_GROUP).write(profileID).write(group).write(node));
    }

    public static void addNodeToGroup(String profileID, String group, String node) {
        Engine.packetHandler.sendToServer(new PacketAccessGui(ADD_NODE_TO_GROUP).write(profileID).write(group).write(node));
    }
}

