/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.access;

import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.api.tile.ITile;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.framework.access.AccessGroup;
import com.builtbroken.mc.framework.access.AccessUser;
import com.builtbroken.mc.framework.access.AccessUtility;
import com.builtbroken.mc.framework.access.wrapper.AccessUserMultiGroup;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.NBTUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class AccessProfile
implements IVirtualObject {
    public static final String SAVE_FOLDER = "bbm/access/profiles/";
    protected List<AccessGroup> groups = new ArrayList<AccessGroup>();
    protected String profileName = "";
    protected String profileID = "LocalHost";
    protected boolean global = false;
    protected File saveFile;

    public AccessProfile() {
    }

    public AccessProfile(boolean global) {
        this.global = global;
        if (global) {
            SaveManager.register(this);
        }
    }

    public AccessProfile(NBTTagCompound nbt) {
        this(nbt, false);
    }

    public AccessProfile(NBTTagCompound nbt, boolean global) {
        this();
        this.load(nbt);
        if (this.profileName == null || this.profileID == null) {
            if (!global) {
                this.generateNew("Default", (ITile)null);
            } else {
                this.generateNew("New Group");
            }
        }
    }

    public AccessProfile generateNew(String name) {
        AccessUtility.loadNewGroupSet(this);
        this.initName(name.trim(), "P_" + name + "_" + System.currentTimeMillis());
        return this;
    }

    public AccessProfile generateNew(String name, ITile entity) {
        AccessUtility.loadNewGroupSet(this);
        this.initName(name.trim(), "LocalHost:" + name);
        return this;
    }

    public AccessProfile generateNew(String name, EntityPlayer player) {
        AccessUtility.loadNewGroupSet(this);
        this.initName(name, player.func_70005_c_() + "_" + System.nanoTime());
        return this;
    }

    public AccessProfile initName(String name, String id) {
        this.profileName = name;
        this.profileID = id;
        return this;
    }

    public String getName() {
        return this.profileName;
    }

    public String getID() {
        return this.profileID;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean containsUser(EntityPlayer player) {
        return this.containsUser(player.func_70005_c_());
    }

    public boolean containsUser(String username) {
        for (AccessGroup group : this.groups) {
            AccessUser user = group.getMember(username);
            if (user == null) continue;
            return true;
        }
        return false;
    }

    public AccessUser getUserAccess(EntityPlayer player) {
        return this.getUserAccess(player.func_70005_c_());
    }

    public AccessUser getUserAccess(String username) {
        for (AccessGroup group : this.groups) {
            AccessUser user = group.getMember(username);
            if (user == null) continue;
            return new AccessUserMultiGroup(this, user);
        }
        return new AccessUser(username).setTemporary(true);
    }

    public List<AccessGroup> getGroupsWithUser(String username) {
        ArrayList<AccessGroup> groups = new ArrayList<AccessGroup>();
        for (AccessGroup group : this.getGroups()) {
            AccessUser user = group.getMember(username);
            if (user == null) continue;
            groups.add(group);
        }
        return groups;
    }

    public List<AccessUser> getUsers() {
        ArrayList<AccessUser> users = new ArrayList<AccessUser>();
        for (AccessGroup group : this.groups) {
            users.addAll(group.getMembers());
        }
        return users;
    }

    public boolean removeUserAccess(String player) {
        boolean re = false;
        for (AccessGroup group : this.groups) {
            AccessUser user = group.getMember(player);
            if (user == null || !group.removeMember(user)) continue;
            re = true;
        }
        if (re) {
            this.onProfileUpdate();
        }
        return re;
    }

    public void onProfileUpdate() {
    }

    public AccessGroup getGroup(String name) {
        return AccessUtility.getGroup(this.getGroups(), name.toLowerCase());
    }

    public AccessGroup removeGroup(String name) {
        return this.removeGroup(this.getGroup(name));
    }

    public AccessGroup removeGroup(AccessGroup group) {
        if (group != null && this.getGroups().contains(group) && this.getGroups().remove(group)) {
            this.onProfileUpdate();
        }
        return group;
    }

    public boolean addGroup(AccessGroup group) {
        if (!this.groups.contains(group) && this.groups.add(group)) {
            this.onProfileUpdate();
            return true;
        }
        return false;
    }

    public AccessGroup getOwnerGroup() {
        return this.getGroup("owner");
    }

    public List<AccessGroup> getGroups() {
        if (this.groups == null) {
            return new ArrayList<AccessGroup>();
        }
        return this.groups;
    }

    public boolean hasNode(EntityPlayer player, String node) {
        return this.getUserAccess(player).hasNode(node);
    }

    public boolean hasNode(String username, String node) {
        return this.getUserAccess(username).hasNode(node);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.profileName = nbt.func_74779_i("name");
        this.global = nbt.func_74767_n("global");
        this.profileID = nbt.func_74779_i("profileID");
        NBTTagList group_list = nbt.func_150295_c("groups", 10);
        if (group_list != null && group_list.func_74745_c() > 0) {
            this.groups.clear();
            for (int i = 0; i < group_list.func_74745_c(); ++i) {
                AccessGroup group = new AccessGroup("", new AccessUser[0]);
                group.load(group_list.func_150305_b(i));
                this.groups.add(group);
            }
            for (AccessGroup group : this.groups) {
                if (group.getExtendGroupName() == null) continue;
                group.setToExtend(this.getGroup(group.getExtendGroupName()));
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.profileName);
        nbt.func_74757_a("global", this.global);
        nbt.func_74778_a("profileID", this.profileID);
        NBTTagList groupTags = new NBTTagList();
        for (AccessGroup group : this.getGroups()) {
            NBTTagCompound groupTag = new NBTTagCompound();
            group.save(groupTag);
            groupTags.func_74742_a((NBTBase)groupTag);
        }
        nbt.func_74782_a("groups", (NBTBase)groupTags);
        return nbt;
    }

    @Override
    public File getSaveFile() {
        if (this.saveFile == null) {
            this.saveFile = new File(NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), AccessProfile.getPathToProfile(this.getID()));
        }
        return this.saveFile;
    }

    public static String getPathToProfile(String name) {
        return SAVE_FOLDER + name + ".dat";
    }

    @Override
    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    @Override
    public boolean shouldSaveForWorld(World world) {
        return world != null && world.field_73011_w.field_76574_g == 0;
    }

    public String toString() {
        return LanguageUtility.getLocal("info.accessprofile.tostring").replaceAll("%p", this.profileName.toString()).replaceAll("%g", this.groups.toString());
    }

    static {
        SaveManager.registerClass("AccessProfile", AccessProfile.class);
    }
}

