/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSpawnStream
extends PacketType {
    public int dim;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;

    public PacketSpawnStream() {
    }

    public PacketSpawnStream(int dim, IPos3D pos, IPos3D pos2) {
        this(dim, pos.x(), pos.y(), pos.z(), pos2.x(), pos2.y(), pos2.z());
    }

    public PacketSpawnStream(int dim, double x, double y, double z, double vx, double vy, double vz) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.vx);
        buffer.writeDouble(this.vy);
        buffer.writeDouble(this.vz);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.vx = buffer.readDouble();
        this.vy = buffer.readDouble();
        this.vz = buffer.readDouble();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76574_g == this.dim) {
            int short1 = 128;
            Random rand = player.field_70170_p.field_73012_v;
            for (int l = 0; l < short1; ++l) {
                double d6 = (double)l / ((double)short1 - 1.0);
                float f = (rand.nextFloat() - 0.5f) * 0.2f;
                float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
                float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
                double d7 = this.vx + (this.x - this.vx) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                double d8 = this.vy + (this.y - this.vy) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                double d9 = this.vz + (this.z - this.vz) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                IWorld world = Engine.minecraft.getWorld(this.dim);
                if (world == null) continue;
                world.spawnParticle("portal", d7, d8, d9, f, f1, f2);
            }
        }
    }
}

