/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSpawnParticleCircle
extends PacketType {
    public String name;
    public int dim;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public double distance;

    public PacketSpawnParticleCircle() {
    }

    public PacketSpawnParticleCircle(String name, IWorldPosition pos, double distance) {
        this(name, pos.oldWorld().field_73011_w.field_76574_g, pos.x(), pos.y(), pos.z(), distance, 0.0, 0.0, 0.0);
    }

    public PacketSpawnParticleCircle(String name, int dim, IPos3D pos, double distance) {
        this(name, dim, pos.x(), pos.y(), pos.z(), distance, 0.0, 0.0, 0.0);
    }

    public PacketSpawnParticleCircle(String name, int dim, double x, double y, double z, double distance) {
        this(name, dim, x, y, z, distance, 0.0, 0.0, 0.0);
    }

    public PacketSpawnParticleCircle(String name, int dim, double x, double y, double z, double distance, double vx, double vy, double vz) {
        this.name = name;
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.distance = distance;
        if ((name == null || name.isEmpty()) && Engine.runningAsDev) {
            throw new IllegalArgumentException("Particle name can not be null or empty");
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.vx);
        buffer.writeDouble(this.vy);
        buffer.writeDouble(this.vz);
        buffer.writeDouble(this.distance);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)("" + this.name));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.vx = buffer.readDouble();
        this.vy = buffer.readDouble();
        this.vz = buffer.readDouble();
        this.distance = buffer.readDouble();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76574_g == this.dim && this.name != null && !this.name.isEmpty()) {
            if (Engine.runningAsDev && this.distance <= 1.0) {
                Engine.logger().error("PacketSpawnParticleCircle: Size of " + this.distance + " is to small to render effectively. " + new Pos(this.x, this.y, this.z).toString());
                return;
            }
            double c = Math.PI * 2 * this.distance;
            int particles = (int)Math.ceil(c) / 2;
            if (particles % 2 == 1) {
                ++particles;
            }
            double angleSeg = 360.0 / (double)(particles *= 5);
            for (int i = 0; i < particles; ++i) {
                EulerAngle angle = new EulerAngle(angleSeg * (double)i, 0.0);
                Pos pos = (Pos)((Pos)angle.toPos().multiply(this.distance)).add(this.x, this.y, this.z);
                player.field_70170_p.func_72869_a(this.name, pos.x(), pos.y(), pos.z(), this.vx, this.vy, this.vz);
            }
        }
    }
}

