/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.world.chunks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public abstract class AbstractChunkProvider
implements IChunkProvider {
    protected final World worldObj;
    protected final String name;

    public AbstractChunkProvider(World world, String name) {
        this.worldObj = world;
        this.name = name;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    protected final void generatePlatform(Chunk chunk, int y, Block block, int meta) {
        this.generatePlatform(chunk, y, 16, 16, 0, 0, block, meta);
    }

    protected final void generatePlatform(Chunk chunk, int y, int sizeX, int sizeZ, int startX, int startZ, Block block, int meta) {
        for (int cx = startX; cx < startX + sizeX; ++cx) {
            for (int cz = startZ; cz < startZ + sizeZ; ++cz) {
                this.setBlock(chunk, cx, y, cz, block, meta);
            }
        }
    }

    protected final void generateSquare(Chunk chunk, int y, int sizeX, int sizeZ, int startX, int startZ, Block block, int meta) {
        for (int cz = startZ; cz < startZ + sizeZ; ++cz) {
            this.setBlock(chunk, startX, y, cz, block, meta);
            this.setBlock(chunk, startX + sizeX - 1, y, cz, block, meta);
        }
        for (int cx = startX + 1; cx < startX + sizeX - 1; ++cx) {
            this.setBlock(chunk, cx, y, startZ, block, meta);
            this.setBlock(chunk, cx, y, startZ + sizeZ - 1, block, meta);
        }
    }

    protected final void generateCorners(Chunk chunk, int y, int size, Block block, int meta) {
        this.generateCorners(chunk, y, size, 0, 0, block, meta);
    }

    protected final void generateCorners(Chunk chunk, int y, int size, int startX, int startZ, Block block, int meta) {
        int reduction = 15 - size;
        int small = reduction / 2;
        int large = 15 - small;
        this.generateCorners(chunk, y, small, large, startX, startZ, block, meta);
    }

    protected final void generateCorners(Chunk chunk, int y, int small, int large, int startX, int startZ, Block block, int meta) {
        this.setBlock(chunk, startX + small, y, startZ + small, block, meta);
        this.setBlock(chunk, startX + large, y, startZ + small, block, meta);
        this.setBlock(chunk, startX + small, y, startZ + large, block, meta);
        this.setBlock(chunk, startX + large, y, startZ + large, block, meta);
    }

    protected final void setBlock(Chunk chunk, int x, int y, int z, Block block, int meta) {
        int l = y >> 4;
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
        if (extendedblockstorage == null) {
            chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(y / 16 * 16, !this.worldObj.field_73011_w.field_76576_e);
        }
        extendedblockstorage.func_150818_a(x, y & 0xF, z, block);
        if (meta >= 0 && meta < 16) {
            extendedblockstorage.func_76654_b(x, y & 0xF, z, meta);
        }
        if (block.func_149750_m() > 0) {
            extendedblockstorage.func_76677_d(x, y & 0xF, z, block.func_149750_m());
        }
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return this.name;
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
        return biomegenbase.func_76747_a(p_73155_1_);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }
}

